/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.subor;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class SuborKaraoke
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean switchMode;

    public SuborKaraoke(CartFile cartFile) {
        super(cartFile, 2, 2);
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.switchMode = BitUtil.getBitBool(value, 7);
        if (this.switchMode) {
            this.setChrBank(1, 1);
        } else {
            this.set2ChrBanks(0, 0);
        }
        this.setNametableMirroring(BitUtil.getBit(value, 6));
        this.setPrgBank(value & 0x3F);
    }

    @Override
    public int readVRAM(int address) {
        if (this.switchMode && address >= 8192 && address <= 16127) {
            this.setChrBank(0, BitUtil.getBit(address, this.nametableMappings[2] == 8192 ? 11 : 10));
        }
        return super.readVRAM(address);
    }
}

