/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.taito;

import nintaco.files.CartFile;
import nintaco.mappers.taito.X1005;
import nintaco.util.BitUtil;

public class X1005b
extends X1005 {
    private static final long serialVersionUID = 0L;

    public X1005b(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 32512 && address < 32768) {
            if (this.ramEnabled) {
                this.memory[address & 0x7F7F] = value;
            }
        } else {
            switch (address) {
                case 32496: {
                    this.writeChrBank(0, value);
                    break;
                }
                case 32497: {
                    this.writeChrBank(2, value);
                    break;
                }
                case 32498: {
                    this.writeChrBank(4, value);
                    break;
                }
                case 32499: {
                    this.writeChrBank(5, value);
                    break;
                }
                case 32500: {
                    this.writeChrBank(6, value);
                    break;
                }
                case 32501: {
                    this.writeChrBank(7, value);
                    break;
                }
                case 32502: 
                case 32503: {
                    break;
                }
                case 32504: 
                case 32505: {
                    this.ramEnabled = 163 == value;
                    break;
                }
                case 32506: 
                case 32507: {
                    this.setPrgBank(4, value);
                    break;
                }
                case 32508: 
                case 32509: {
                    this.setPrgBank(5, value);
                    break;
                }
                case 32510: 
                case 32511: {
                    this.setPrgBank(6, value);
                    break;
                }
                default: {
                    this.memory[address] = value;
                }
            }
        }
    }

    @Override
    protected void writeChrBank(int bank, int value) {
        if (bank < 4) {
            this.chrBanks[bank] = (value & 0x7F) << 10;
            this.chrBanks[bank + 1] = this.chrBanks[bank] + 1024;
            int n = BitUtil.getBitBool(value, 7) ? 8192 : 9216;
            this.nametableMappings[bank + 1] = n;
            this.nametableMappings[bank] = n;
        } else {
            this.chrBanks[bank] = value << 10;
        }
    }
}

