/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.thq;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class CPROM
extends Mapper {
    private static final long serialVersionUID = 0L;

    public CPROM(CartFile cartFile) {
        super(cartFile, 2, 2);
        this.xram = new int[16384];
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.xram[this.chrBanks[address >> 12] | address & 0xFFF];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            this.xram[this.chrBanks[address >> 12] | address & 0xFFF] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.setChrBank(1, value & 3);
    }
}

