/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.txc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC1;
import nintaco.util.BitUtil;

public class Txc01_22110_000
extends MMC1 {
    private static final long serialVersionUID = 0L;
    private int mode;
    private int latch;

    public Txc01_22110_000(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.latch = 0;
        this.mode = 0;
        this.setNametableMirroring(0);
        this.updateState();
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        if (BitUtil.getBitBool(this.mode, 0)) {
            this.updateBanks();
        } else {
            int upper = (this.mode & 2) << 1;
            this.setPrgBank(2, upper | this.latch >> 4 & 3);
            this.setPrgBank(3, upper | 3);
            this.set2ChrBanks(0, this.latch & 0xE);
        }
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.mode, 0)) {
            super.setPrgBank(bank, 8 | value & 7);
        } else {
            super.setPrgBank(bank, value);
        }
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (BitUtil.getBitBool(this.mode, 0)) {
            super.setChrBank(bank, 0x20 | value & 0x1F);
        } else {
            super.setChrBank(bank, value);
        }
    }

    private void writeMode(int value) {
        this.mode = value;
        this.updateState();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE100) == 16640) {
            this.writeMode(value);
        } else if (BitUtil.getBitBool(this.mode, 0)) {
            super.writeMemory(address, value);
        } else if (address >= 32768) {
            this.latch = value;
            this.updateState();
        } else {
            this.memory[address] = value;
        }
    }

    @Override
    protected void writeControl(int value) {
        this.controlRegister = value;
        this.setNametableMirroring(0);
        this.prgBankMode = value >> 2 & 3;
        this.chrBankMode = BitUtil.getBitBool(value, 4);
        this.updateBanks();
    }
}

