/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.txc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public abstract class TxcLatch
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected boolean increase;
    protected int output;
    protected int invert;
    protected int staging;
    protected int accumulator;
    protected int inverter;
    protected boolean A;
    protected boolean B;
    protected boolean X;
    protected boolean Y;

    public TxcLatch(CartFile cartFile, int prgBanksSize, int chrBanksSize) {
        super(cartFile, prgBanksSize, chrBanksSize);
    }

    @Override
    public void init() {
        this.inverter = 0;
        this.accumulator = 0;
        this.staging = 0;
        this.invert = 0;
        this.output = 0;
        this.A = false;
        this.X = false;
        this.Y = false;
        this.B = true;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    protected abstract void updateState();

    protected int readLatch(int address) {
        int result = 255;
        if ((address & 0xE103) == 16640) {
            result = (this.inverter ^ this.invert) & 0xF8 | this.accumulator & 7;
            this.Y = this.X | BitUtil.getBitBool(result, 4);
            this.updateState();
        }
        return result;
    }

    protected void writeLatch(int address, int value) {
        switch (address & 0xE103) {
            case 16640: {
                if (this.increase) {
                    ++this.accumulator;
                    break;
                }
                this.accumulator = (this.accumulator & 0xF8 | this.staging & 7) ^ this.invert;
                break;
            }
            case 16641: {
                this.invert = BitUtil.getBitBool(value, 0) ? 255 : 0;
                break;
            }
            case 16642: {
                this.staging = value & 7;
                this.inverter = value & 0xF8;
                break;
            }
            case 16643: {
                this.increase = BitUtil.getBitBool(value, 0);
                break;
            }
            default: {
                if ((address & 0x8000) == 0) break;
                this.output = (this.inverter & 8) << 1 | this.accumulator & 0xF;
            }
        }
        this.X = this.invert != 0 ? this.A : this.B;
        this.Y = this.X | (value & 0x10) != 0;
        this.updateState();
    }
}

