/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC64In1NoRepeat
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];

    public BMC64In1NoRepeat(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.regs[0] = 128;
        this.regs[1] = 67;
        this.regs[3] = 0;
        this.regs[2] = 0;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        if (BitUtil.getBitBool(this.regs[0], 7)) {
            if (BitUtil.getBitBool(this.regs[1], 7)) {
                int b = (this.regs[1] & 0x1F) << 1;
                this.setPrgBank(2, b);
                this.setPrgBank(3, b | 1);
            } else {
                int bank = (this.regs[1] & 0x1F) << 1 | this.regs[1] >> 6 & 1;
                this.setPrgBank(2, bank);
                this.setPrgBank(3, bank);
            }
        } else {
            this.setPrgBank(3, (this.regs[1] & 0x1F) << 1 | this.regs[1] >> 6 & 1);
        }
        this.setNametableMirroring(BitUtil.getBit(this.regs[0], 5));
        this.setChrBank(this.regs[2] << 2 | this.regs[0] >> 1 & 3);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 32768) {
            this.regs[3] = value;
            this.updateState();
        } else if (address >= 20480 && address <= 20483) {
            this.regs[address & 3] = value;
            this.updateState();
        }
        this.memory[address] = value;
    }
}

