/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMCK3006
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean mmc3Mode;

    public BMCK3006(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBankAndMode(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void updatePrgBanks() {
        if (this.mmc3Mode) {
            super.updatePrgBanks();
        }
    }

    private void writeOuterBankAndMode(int address) {
        this.mmc3Mode = BitUtil.getBitBool(address, 5);
        if (this.mmc3Mode) {
            this.setPrgBlock((address & 0x18) << 1, 15);
        } else {
            this.setPrgBlock(0, -1);
            if ((address & 7) == 6) {
                this.set4PrgBanks(4, (address & 0x1E) << 1);
            } else {
                this.set2PrgBanks(4, (address & 0x1F) << 1);
                this.set2PrgBanks(6, (address & 0x1F) << 1);
            }
        }
        this.setChrBlock((address & 0x18) << 4, 127);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.prgRamWritesEnabled && this.prgRamChipEnabled && (0xE000 & address) == 24576) {
            this.writeOuterBankAndMode(address);
        }
        super.writeMemory(address, value);
    }
}

