/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class D1038
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int register;
    private int dipSwitch;

    public D1038(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void resetting() {
        this.dipSwitch = this.dipSwitch + 1 & 3;
        this.init();
    }

    private void updateBanks() {
        if (BitUtil.getBitBool(this.register, 7)) {
            int bank = (this.register & 0x70) >> 4;
            this.setPrgBank(2, bank);
            this.setPrgBank(3, bank);
        } else {
            int b = (this.register & 0x60) >> 4;
            this.setPrgBank(2, b);
            this.setPrgBank(3, b | 1);
        }
        this.setChrBank(this.register & 7);
        this.setNametableMirroring(BitUtil.getBit(this.register, 3));
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576 && BitUtil.getBitBool(this.register, 8)) {
            return this.dipSwitch;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.register = address;
        this.updateBanks();
    }
}

