/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.btl;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VRC2And4;

public class BTL900218
extends VRC2And4 {
    private static final long serialVersionUID = 0L;
    private int irqCounter;

    public BTL900218(CartFile cartFile) {
        super(cartFile);
        this.prgHigh = 32;
        this.variant = 7;
    }

    @Override
    public void resetting() {
        this.irqEnabled = false;
        this.irqCounter = 0;
        this.cpu.setMapperIrq(false);
    }

    @Override
    public void update() {
        if (this.irqEnabled && (++this.irqCounter & 0x400) != 0) {
            this.cpu.setMapperIrq(true);
        }
    }

    private void writeIRQ(int address) {
        switch (address & 0xC) {
            case 8: {
                this.irqEnabled = true;
                break;
            }
            case 12: {
                this.irqEnabled = false;
                this.irqCounter = 0;
                this.cpu.setMapperIrq(false);
            }
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address & 0xF000) == 61440) {
            this.writeIRQ(address);
        } else {
            super.writeRegister(address, value);
        }
    }
}

