/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class AX5705
extends Mapper {
    private static final long serialVersionUID = 0L;

    public AX5705(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
        Arrays.fill(this.chrBanks, 0);
    }

    private void setChrBank(int bank, int value, boolean high) {
        this.chrBanks[bank] = high ? this.chrBanks[bank] & 0x3C00 | ((value & 4) >> 1 | (value & 2) << 1 | value & 9) << 4 << 10 : this.chrBanks[bank] & 0x3C000 | (value & 0xF) << 10;
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 40968) {
            boolean high = BitUtil.getBitBool(address, 0);
            switch (address & 0xF00E) {
                case 40968: {
                    this.setChrBank(0, value, high);
                    break;
                }
                case 40970: {
                    this.setChrBank(1, value, high);
                    break;
                }
                case 49152: {
                    this.setChrBank(2, value, high);
                    break;
                }
                case 49154: {
                    this.setChrBank(3, value, high);
                    break;
                }
                case 49160: {
                    this.setChrBank(4, value, high);
                    break;
                }
                case 49162: {
                    this.setChrBank(5, value, high);
                    break;
                }
                case 57344: {
                    this.setChrBank(6, value, high);
                    break;
                }
                case 57346: {
                    this.setChrBank(7, value, high);
                }
            }
        } else {
            switch (address & 0xF00F) {
                case 32768: {
                    this.setPrgBank(4, (value & 2) << 2 | (value & 8) >> 2 | value & 5);
                    break;
                }
                case 32776: {
                    this.setNametableMirroring(value & 1);
                    break;
                }
                case 40960: {
                    this.setPrgBank(5, (value & 2) << 2 | (value & 8) >> 2 | value & 5);
                }
            }
        }
    }
}

