/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class DRAGONFIGHTER
extends MMC3 {
    private int reg0;
    private int reg1;
    private int reg2;

    public DRAGONFIGHTER(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (bank == 4) {
            super.setPrgBank(4, this.reg0 & 0x1F);
        } else {
            super.setPrgBank(bank, value);
        }
    }

    @Override
    protected void setChrBank(int bank, int value) {
        switch (bank) {
            case 0: {
                int val = (value >> 1 ^ this.reg1) << 1;
                super.setChrBank(0, val);
                super.setChrBank(1, val | 1);
                break;
            }
            case 2: {
                int val = (value >> 1 | (this.reg2 & 0x40) << 1) << 1;
                super.setChrBank(2, val);
                super.setChrBank(3, val | 1);
                break;
            }
            case 4: {
                int val = (this.reg2 & 0x3F) << 2;
                super.setChrBank(4, val);
                super.setChrBank(5, val | 1);
                super.setChrBank(6, val | 2);
                super.setChrBank(7, val | 3);
                break;
            }
        }
    }

    @Override
    public int readMemory(int address) {
        if ((0xF000 & address) == 24576) {
            if (!BitUtil.getBitBool(address, 0)) {
                if ((this.reg0 & 0xE0) == 192) {
                    this.reg1 = super.readMemory(106);
                } else {
                    this.reg2 = super.readMemory(255);
                }
                this.updatePrgBanks();
                this.setChrBank(0, this.R[0] & 0xFE);
                this.setChrBank(1, this.R[0] | 1);
                this.setChrBank(2, this.R[1] & 0xFE);
                this.setChrBank(3, this.R[1] | 1);
                this.setChrBank(4, this.R[2]);
                this.setChrBank(5, this.R[3]);
                this.setChrBank(6, this.R[4]);
                this.setChrBank(7, this.R[5]);
            }
            return 0;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((0xF000 & address) == 24576) {
            if (!BitUtil.getBitBool(address, 0)) {
                this.reg0 = value;
                this.updateBanks();
            }
        } else {
            super.writeMemory(address, value);
        }
    }
}

