/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class LH10
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[8];
    private int register;

    public LH10(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.register = 0;
        this.setPrgBank(3, -2);
        this.setPrgBank(7, -1);
        this.setChrBank(0);
        this.updateBanks();
    }

    private void updateBanks() {
        this.setPrgBank(4, this.regs[6]);
        this.setPrgBank(5, this.regs[7]);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 49152) {
            return this.memory[address];
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address & 0xE000) != 49152) {
            switch (address & 0xE001) {
                case 32768: {
                    this.register = value & 7;
                    break;
                }
                case 32769: {
                    this.regs[this.register] = value;
                    this.updateBanks();
                }
            }
        }
    }
}

