/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class LH32
extends Mapper {
    private static final long serialVersionUID = 0L;

    public LH32(CartFile cartFile) {
        super(cartFile, 8, 1, 24576, 24576);
    }

    @Override
    public void init() {
        this.setChrBank(0);
        this.setPrgBank(3, 0);
        this.setPrgBank(4, -4);
        this.setPrgBank(5, -3);
        this.setPrgBank(7, -1);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 49152) {
            return this.memory[address];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address == 24576) {
            this.setPrgBank(3, value);
        }
    }
}

