/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class LH51
extends Mapper {
    private static final long serialVersionUID = 0L;

    public LH51(CartFile cartFile) {
        super(cartFile, 8, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 13);
        this.setPrgBank(6, 14);
        this.setPrgBank(7, 15);
        this.setChrBank(0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE000) {
            case 32768: {
                this.setPrgBank(4, value & 0xF);
                break;
            }
            case 57344: {
                this.setNametableMirroring(BitUtil.getBit(value, 3));
            }
        }
    }
}

