/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class SA9602B
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] EXPREGS = new int[2];

    public SA9602B(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected int getChrRamSize(CartFile cartFile) {
        return 32768;
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.EXPREGS[1] << 6 | value);
        if (this.prgMode) {
            super.setPrgBank(4, 62);
        } else {
            super.setPrgBank(6, 62);
        }
        super.setPrgBank(7, 63);
    }

    @Override
    public void writeRegister(int address, int value) {
        if (address < 49152) {
            switch (address & 0xE001) {
                case 32768: {
                    this.EXPREGS[0] = value;
                    break;
                }
                case 32769: {
                    if ((this.EXPREGS[0] & 7) >= 6) break;
                    this.EXPREGS[1] = value >> 6;
                    this.updatePrgBanks();
                }
            }
        }
        super.writeRegister(address, value);
    }
}

