/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class UNL158B
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] LUT = new int[]{0, 0, 0, 1, 2, 4, 15, 0};
    private int reg;

    public UNL158B(CartFile cartFile) {
        super(cartFile);
        this.prgBlockMask = 15;
    }

    @Override
    public void init() {
        this.R[6] = 0;
        this.R[7] = 1;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void updatePrgBanks() {
        if (BitUtil.getBitBool(this.reg, 7)) {
            int val = (this.reg & 7) << 1;
            if (BitUtil.getBitBool(this.reg, 5)) {
                this.setPrgBank(4, val &= 0xC);
                this.setPrgBank(5, val | 1);
                this.setPrgBank(6, val | 2);
                this.setPrgBank(7, val | 3);
            } else {
                this.setPrgBank(4, val);
                this.setPrgBank(5, val | 1);
                this.setPrgBank(6, val);
                this.setPrgBank(7, val | 1);
            }
        } else {
            super.updatePrgBanks();
        }
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return LUT[address & 7];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF007) == 20480) {
            this.reg = value;
            this.updatePrgBanks();
        }
        super.writeMemory(address, value);
    }
}

