/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class UNL22211
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];

    public UNL22211(CartFile cartFile) {
        super(cartFile, 2, 1);
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    @Override
    public int readMemory(int address) {
        if (address == 16640) {
            return this.regs[1] ^ this.regs[2] | 0x40;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xFFFC) == 16640) {
            this.regs[address & 3] = value;
        } else {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.updateBanks();
    }

    public void updateBanks() {
        this.setPrgBank(this.regs[2] >> 2 & 1);
        this.setChrBank(this.regs[2] & 3);
    }
}

