/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.sunsoft.fme7.SunsoftFME7;
import nintaco.util.BitUtil;

public class UNL831128C
extends SunsoftFME7 {
    private static final long serialVersionUID = 0L;
    private int irqControl;
    private int irqLatch;
    private int irqCycles;

    public UNL831128C(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void update() {
        if ((this.irqControl & 2) != 0 && ((this.irqControl & 4) != 0 || (this.irqCycles -= 3) <= 0)) {
            if ((this.irqControl & 4) == 0) {
                this.irqCycles += 341;
            }
            if (this.irqCounter == 255) {
                this.irqCounter = this.irqLatch;
                this.cpu.setMapperIrq(true);
            } else {
                ++this.irqCounter;
            }
        }
        this.audio.update();
    }

    private void writeIrqControl(int value) {
        this.irqControl = value;
        if (BitUtil.getBitBool(this.irqControl, 1)) {
            this.irqCounter = this.irqLatch;
            this.irqCycles = 341;
        }
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqAcknowledge() {
        this.irqControl = BitUtil.setBit(this.irqControl, 1, BitUtil.getBitBool(this.irqControl, 0));
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqLatch(int value) {
        this.irqLatch = value;
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xF00F) {
            case 40973: 
            case 49165: {
                this.writeIrqControl(value);
                break;
            }
            case 40974: 
            case 49166: {
                this.writeIrqAcknowledge();
                break;
            }
            case 40975: 
            case 49167: {
                this.writeIrqLatch(value);
                break;
            }
            default: {
                super.writeMemory(address, value);
            }
        }
    }
}

