/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper162
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];

    public Mapper162(CartFile cartFile) {
        super(cartFile, 2, 1);
    }

    @Override
    public void init() {
        this.regs[0] = 3;
        this.regs[1] = 0;
        this.regs[2] = 0;
        this.regs[3] = 7;
        this.setChrBank(0);
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateBanks() {
        switch (this.regs[3] & 5) {
            case 0: {
                this.setPrgBank(this.regs[0] & 0xC | this.regs[1] & 2 | (this.regs[2] & 0xF) << 4);
                break;
            }
            case 1: {
                this.setPrgBank(this.regs[0] & 0xC | (this.regs[2] & 0xF) << 4);
                break;
            }
            case 4: {
                this.setPrgBank(this.regs[0] & 0xE | this.regs[1] >> 1 & 1 | (this.regs[2] & 0xF) << 4);
                break;
            }
            case 5: {
                this.setPrgBank(this.regs[0] & 0xF | (this.regs[2] & 0xF) << 4);
            }
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xF000) == 20480) {
            this.regs[address >> 8 & 3] = value;
            this.updateBanks();
        }
    }
}

