/*
 * Decompiled with CFR 0.152.
 */
package nintaco.movie;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteOrder;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Buffer;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;

public class VideoFile {
    private final MovieWriter movieWriter;
    private final int videoTrack;
    private final int audioTrack;
    private final Buffer videoBuffer;
    private final Buffer audioBuffer;
    private final double secondsPerFrame;
    private final byte[] audioData;
    private final boolean recordAudio;
    private int videoFrame;
    private int audioFrame;
    private int audioIndex;
    private boolean closed;

    public VideoFile(String fileName, boolean avi, double framesPerSecond, int width, int height, boolean recordAudio) throws Throwable {
        this(new File(fileName), avi, framesPerSecond, width, height, recordAudio);
    }

    public VideoFile(File file, boolean avi, double framesPerSecond, int width, int height, boolean recordAudio) throws Throwable {
        this.secondsPerFrame = 1.0 / framesPerSecond;
        this.movieWriter = Registry.getInstance().getWriter(new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, avi ? "video/avi" : "video/quicktime"}), file);
        this.videoTrack = this.movieWriter.addTrack(new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, 24, VideoFormatKeys.FrameRateKey, Rational.valueOf(framesPerSecond), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), VideoFormatKeys.KeyFrameIntervalKey, (int)Math.round(framesPerSecond * 60.0)}));
        this.videoBuffer = new Buffer();
        this.videoBuffer.format = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image"});
        this.videoBuffer.track = this.videoTrack;
        this.videoBuffer.sampleDuration = Rational.valueOf(this.secondsPerFrame);
        this.recordAudio = recordAudio;
        if (recordAudio) {
            this.audioBuffer = new Buffer();
            this.audioBuffer.format = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, Rational.valueOf(48000.0), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ByteOrderKey, ByteOrder.LITTLE_ENDIAN});
            this.audioData = new byte[96000];
            this.audioBuffer.data = this.audioData;
            this.audioBuffer.track = this.audioTrack = this.movieWriter.addTrack(this.audioBuffer.format);
        } else {
            this.audioBuffer = null;
            this.audioTrack = 0;
            this.audioData = null;
        }
    }

    public synchronized void writeImage(BufferedImage image) throws Throwable {
        if (this.closed) {
            return;
        }
        this.videoBuffer.data = image;
        this.videoBuffer.timeStamp = Rational.valueOf(this.secondsPerFrame * (double)this.videoFrame);
        this.videoBuffer.sequenceNumber = this.videoFrame++;
        this.movieWriter.write(this.videoTrack, this.videoBuffer);
    }

    public synchronized void writeAudioSample(int sample) throws Throwable {
        if (this.closed || !this.recordAudio) {
            return;
        }
        this.audioData[this.audioIndex++] = (byte)(sample & 0xFF);
        this.audioData[this.audioIndex++] = (byte)(sample >> 8 & 0xFF);
        if (this.audioIndex == this.audioData.length) {
            this.audioIndex = 0;
            this.audioBuffer.length = this.audioData.length;
            this.audioBuffer.sampleCount = this.audioData.length >> 1;
            this.audioBuffer.sampleDuration = Rational.ONE;
            this.audioBuffer.timeStamp = Rational.valueOf(this.audioFrame);
            this.audioBuffer.sequenceNumber = this.audioFrame++;
            this.movieWriter.write(this.audioTrack, this.audioBuffer);
        }
    }

    public synchronized void close() throws Throwable {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.recordAudio && this.audioIndex > 0) {
            this.audioBuffer.length = this.audioIndex = 0;
            this.audioBuffer.sampleCount = this.audioIndex >> 1;
            this.audioBuffer.sampleDuration = Rational.valueOf(this.audioIndex, this.audioBuffer.length);
            this.audioBuffer.timeStamp = Rational.valueOf(this.audioFrame);
            this.audioBuffer.sequenceNumber = this.audioFrame;
            this.movieWriter.write(this.audioTrack, this.audioBuffer);
        }
        this.movieWriter.close();
    }
}

