/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static InetAddress[] toArray(List<InetAddress> addresses) {
        InetAddress[] array = new InetAddress[addresses.size()];
        addresses.toArray(array);
        return array;
    }

    public static List<InetAddress> sortAddresses(List<InetAddress> addresses) {
        Collections.sort(addresses, (a, b) -> Objects.compare(a.getHostAddress(), b.getHostAddress(), String.CASE_INSENSITIVE_ORDER));
        return addresses;
    }

    public static List<InetAddress> getNetworkInterfaces() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    addresses.add(e.nextElement());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return addresses;
    }
}

