/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.ImageOutputStreamAdapter;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.DataAtomOutputStream;

public class QuickTimeOutputStream
extends AbstractQuickTimeStream {
    public QuickTimeOutputStream(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
        this.init();
    }

    public QuickTimeOutputStream(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
        this.init();
    }

    private void init() {
        this.creationTime = new Date();
        this.modificationTime = new Date();
    }

    public void setMovieTimeScale(long timeScale) {
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        this.movieTimeScale = timeScale;
    }

    public long getMovieTimeScale() {
        return this.movieTimeScale;
    }

    public long getMediaTimeScale(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaTimeScale;
    }

    public long getMediaDuration(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaDuration;
    }

    public long getUneditedTrackDuration(int track) {
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        return t.mediaDuration * t.mediaTimeScale / this.movieTimeScale;
    }

    public long getTrackDuration(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get(track)).getTrackDuration(this.movieTimeScale);
    }

    public long getMovieDuration() {
        long duration = 0L;
        for (AbstractQuickTimeStream.Track t : this.tracks) {
            duration = Math.max(duration, t.getTrackDuration(this.movieTimeScale));
        }
        return duration;
    }

    public void setVideoColorTable(int track, ColorModel icm) {
        if (icm instanceof IndexColorModel) {
            AbstractQuickTimeStream.VideoTrack t = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
            t.videoColorTable = (IndexColorModel)icm;
        }
    }

    public IndexColorModel getVideoColorTable(int track) {
        AbstractQuickTimeStream.VideoTrack t = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        return t.videoColorTable;
    }

    public void setEditList(int track, AbstractQuickTimeStream.Edit[] editList) {
        if (editList != null && editList.length > 0 && editList[editList.length - 1].mediaTime == -1) {
            throw new IllegalArgumentException("Edit list must not end with empty edit.");
        }
        ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).editList = editList;
    }

    public int addVideoTrack(String compressionType, String compressorName, long timeScale, int width, int height, int depth, int syncInterval) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("compressionType must be 4 characters long:" + compressionType);
        }
        if (compressorName == null || compressorName.length() < 1 || compressorName.length() > 32) {
            throw new IllegalArgumentException("compressorName must be between 1 and 32 characters long:" + (compressorName == null ? "null" : "\"" + compressorName + "\""));
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width and height must be greater than 0, width:" + width + " height:" + height);
        }
        AbstractQuickTimeStream.VideoTrack t = new AbstractQuickTimeStream.VideoTrack();
        t.mediaCompressionType = compressionType;
        t.mediaCompressorName = compressorName;
        t.mediaTimeScale = timeScale;
        t.width = width;
        t.height = height;
        t.videoDepth = depth;
        t.syncInterval = syncInterval;
        t.format = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, compressionType, VideoFormatKeys.CompressorNameKey, compressorName, VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, depth, AudioFormatKeys.FrameRateKey, new Rational(timeScale, 1L)});
        this.tracks.add(t);
        return this.tracks.size() - 1;
    }

    public int addAudioTrack(String compressionType, long timeScale, double sampleRate, int numberOfChannels, int sampleSizeInBits, boolean isCompressed, int frameDuration, int frameSize, boolean signed, ByteOrder byteOrder) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("audioFormat must be 4 characters long:" + compressionType);
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (timeScale != (long)((int)Math.floor(sampleRate))) {
            throw new IllegalArgumentException("timeScale: " + timeScale + " must match integer portion of sampleRate: " + sampleRate);
        }
        if (numberOfChannels != 1 && numberOfChannels != 2) {
            throw new IllegalArgumentException("numberOfChannels must be 1 or 2: " + numberOfChannels);
        }
        if (sampleSizeInBits != 8 && sampleSizeInBits != 16) {
            throw new IllegalArgumentException("sampleSize must be 8 or 16: " + numberOfChannels);
        }
        AbstractQuickTimeStream.AudioTrack t = new AbstractQuickTimeStream.AudioTrack();
        t.mediaCompressionType = compressionType;
        t.mediaTimeScale = timeScale;
        t.soundSampleRate = sampleRate;
        t.soundCompressionId = isCompressed ? -2 : -1;
        t.soundNumberOfChannels = numberOfChannels;
        t.soundSampleSize = sampleSizeInBits;
        t.soundSamplesPerPacket = frameDuration;
        if (isCompressed) {
            t.soundBytesPerPacket = frameSize;
            t.soundBytesPerFrame = frameSize * numberOfChannels;
        } else {
            t.soundBytesPerPacket = frameSize / numberOfChannels;
            t.soundBytesPerFrame = frameSize;
        }
        t.soundBytesPerSample = sampleSizeInBits / 8;
        t.format = new Format(new Object[]{AudioFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.MimeTypeKey, "video/quicktime", AudioFormatKeys.EncodingKey, compressionType, AudioFormatKeys.SampleRateKey, Rational.valueOf(sampleRate), AudioFormatKeys.SampleSizeInBitsKey, sampleSizeInBits, AudioFormatKeys.ChannelsKey, numberOfChannels, AudioFormatKeys.FrameSizeKey, frameSize, AudioFormatKeys.SampleRateKey, Rational.valueOf(sampleRate), AudioFormatKeys.SignedKey, signed, AudioFormatKeys.ByteOrderKey, byteOrder});
        this.tracks.add(t);
        return this.tracks.size() - 1;
    }

    public void setCompressionQuality(int track, float newValue) {
        AbstractQuickTimeStream.VideoTrack vt = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        vt.videoQuality = newValue;
    }

    public float getCompressionQuality(int track) {
        return ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).videoQuality;
    }

    public void setSyncInterval(int track, int i) {
        ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).syncInterval = i;
    }

    public int getSyncInterval(int track) {
        return ((AbstractQuickTimeStream.VideoTrack)this.tracks.get((int)track)).syncInterval;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setModificationTime(Date modificationTime) {
        this.modificationTime = modificationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public double getPreferredRate() {
        return this.preferredRate;
    }

    public void setPreferredRate(double preferredRate) {
        this.preferredRate = preferredRate;
    }

    public double getPreferredVolume() {
        return this.preferredVolume;
    }

    public void setPreferredVolume(double preferredVolume) {
        this.preferredVolume = preferredVolume;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getPosterTime() {
        return this.posterTime;
    }

    public void setPosterTime(long posterTime) {
        this.posterTime = posterTime;
    }

    public long getPreviewDuration() {
        return this.previewDuration;
    }

    public void setPreviewDuration(long previewDuration) {
        this.previewDuration = previewDuration;
    }

    public long getPreviewTime() {
        return this.previewTime;
    }

    public void setPreviewTime(long previewTime) {
        this.previewTime = previewTime;
    }

    public long getSelectionDuration() {
        return this.selectionDuration;
    }

    public void setSelectionDuration(long selectionDuration) {
        this.selectionDuration = selectionDuration;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setSelectionTime(long selectionTime) {
        this.selectionTime = selectionTime;
    }

    public void setMovieTransformationMatrix(double[] matrix) {
        if (matrix.length != 9) {
            throw new IllegalArgumentException("matrix must have 9 elements, matrix.length=" + matrix.length);
        }
        System.arraycopy(matrix, 0, this.movieMatrix, 0, 9);
    }

    public double[] getMovieTransformationMatrix() {
        return (double[])this.movieMatrix.clone();
    }

    public void setTransformationMatrix(int track, double[] matrix) {
        if (matrix.length != 9) {
            throw new IllegalArgumentException("matrix must have 9 elements, matrix.length=" + matrix.length);
        }
        System.arraycopy(matrix, 0, ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).matrix, 0, 9);
    }

    public double[] getTransformationMatrix(int track) {
        return (double[])((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).matrix.clone();
    }

    protected void ensureStarted() throws IOException {
        this.ensureOpen();
        if (this.state == AbstractQuickTimeStream.States.FINISHED) {
            throw new IOException("Can not write into finished movie.");
        }
        if (this.state != AbstractQuickTimeStream.States.STARTED) {
            this.writeProlog();
            this.mdatAtom = new AbstractQuickTimeStream.WideDataAtom("mdat");
            this.state = AbstractQuickTimeStream.States.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSample(int track, File file, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            this.writeSample(track, in, duration, isSync);
        }
    }

    public void writeSample(int track, InputStream in, long duration, boolean isSync) throws IOException {
        int len;
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        t.addSample(new AbstractQuickTimeStream.Sample(duration, offset, length), 1, isSync);
    }

    public void writeSample(int track, byte[] data, long duration, boolean isSync) throws IOException {
        this.writeSample(track, data, 0, data.length, duration, isSync);
    }

    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        t.addSample(new AbstractQuickTimeStream.Sample(duration, offset, len), 1, isSync);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, long sampleDuration, boolean isSync) throws IOException {
        this.writeSamples(track, sampleCount, data, 0, data.length, sampleDuration, isSync);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration) throws IOException {
        this.writeSamples(track, sampleCount, data, off, len, sampleDuration, true);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (sampleDuration <= 0L) {
            throw new IllegalArgumentException("sampleDuration must be greater 0, sampleDuration=" + sampleDuration + " track=" + track);
        }
        if (sampleCount <= 0) {
            throw new IllegalArgumentException("sampleCount must be greater 0, sampleCount=" + sampleCount + " track=" + track);
        }
        if (len % sampleCount != 0) {
            throw new IllegalArgumentException("len must be divisable by sampleCount len=" + len + " sampleCount=" + sampleCount + " track=" + track);
        }
        AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        int sampleLength = len / sampleCount;
        AbstractQuickTimeStream.Sample first = new AbstractQuickTimeStream.Sample(sampleDuration, offset, sampleLength);
        AbstractQuickTimeStream.Sample last = new AbstractQuickTimeStream.Sample(sampleDuration, offset + (long)(sampleLength * (sampleCount - 1)), sampleLength);
        t.addChunk(new AbstractQuickTimeStream.Chunk(first, last, sampleCount, 1), isSync);
    }

    public boolean isDataLimitReached() {
        try {
            long maxMediaDuration = 0L;
            for (AbstractQuickTimeStream.Track t : this.tracks) {
                maxMediaDuration = Math.max(t.mediaDuration, maxMediaDuration);
            }
            return this.getRelativeStreamPosition() > 0x2000000000000000L || maxMediaDuration > 0x2000000000000000L;
        }
        catch (IOException ex) {
            return true;
        }
    }

    public void close() throws IOException {
        try {
            if (this.state == AbstractQuickTimeStream.States.STARTED) {
                this.finish();
            }
        }
        finally {
            if (this.state != AbstractQuickTimeStream.States.CLOSED) {
                this.out.close();
                this.state = AbstractQuickTimeStream.States.CLOSED;
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != AbstractQuickTimeStream.States.FINISHED) {
            int n = this.tracks.size();
            for (int i = 0; i < n; ++i) {
            }
            this.mdatAtom.finish();
            this.writeEpilog();
            this.state = AbstractQuickTimeStream.States.FINISHED;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.state == AbstractQuickTimeStream.States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void writeProlog() throws IOException {
        AbstractQuickTimeStream.DataAtom ftypAtom = new AbstractQuickTimeStream.DataAtom("ftyp");
        DataAtomOutputStream d = ftypAtom.getOutputStream();
        d.writeType("qt  ");
        d.writeBCD4(2005);
        d.writeBCD2(3);
        d.writeBCD2(0);
        d.writeType("qt  ");
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        ftypAtom.finish();
    }

    private void writeEpilog() throws IOException {
        long duration = this.getMovieDuration();
        this.moovAtom = new AbstractQuickTimeStream.CompositeAtom("moov");
        AbstractQuickTimeStream.DataAtom leaf = new AbstractQuickTimeStream.DataAtom("mvhd");
        this.moovAtom.add(leaf);
        DataAtomOutputStream d = leaf.getOutputStream();
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeMacTimestamp(this.creationTime);
        d.writeMacTimestamp(this.modificationTime);
        d.writeUInt(this.movieTimeScale);
        d.writeUInt(duration);
        d.writeFixed16D16(this.preferredRate);
        d.writeFixed8D8(this.preferredVolume);
        d.write(new byte[10]);
        d.writeFixed16D16(this.movieMatrix[0]);
        d.writeFixed16D16(this.movieMatrix[1]);
        d.writeFixed2D30(this.movieMatrix[2]);
        d.writeFixed16D16(this.movieMatrix[3]);
        d.writeFixed16D16(this.movieMatrix[4]);
        d.writeFixed2D30(this.movieMatrix[5]);
        d.writeFixed16D16(this.movieMatrix[6]);
        d.writeFixed16D16(this.movieMatrix[7]);
        d.writeFixed2D30(this.movieMatrix[8]);
        d.writeUInt(this.previewTime);
        d.writeUInt(this.previewDuration);
        d.writeUInt(this.posterTime);
        d.writeUInt(this.selectionTime);
        d.writeUInt(this.selectionDuration);
        d.writeUInt(this.currentTime);
        d.writeUInt(this.tracks.size() + 1);
        int n = this.tracks.size();
        for (int i = 0; i < n; ++i) {
            AbstractQuickTimeStream.Track t = (AbstractQuickTimeStream.Track)this.tracks.get(i);
            t.writeTrackAtoms(i, this.moovAtom, this.modificationTime);
        }
        this.moovAtom.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toWebOptimizedMovie(File outputFile, boolean compressHeader) throws IOException {
        this.finish();
        long originalMdatOffset = this.mdatAtom.getOffset();
        AbstractQuickTimeStream.CompositeAtom originalMoovAtom = this.moovAtom;
        this.mdatOffset = 0L;
        ImageOutputStream originalOut = this.out;
        try {
            int read;
            Object buf;
            this.out = null;
            if (compressHeader) {
                buf = new ByteArrayOutputStream();
                int maxIteration = 5;
                long compressionHeadersSize = 48L;
                long headerSize = 0L;
                long freeSize = 0L;
                while (true) {
                    this.mdatOffset = compressionHeadersSize + headerSize + freeSize;
                    ((ByteArrayOutputStream)buf).reset();
                    DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)buf);
                    this.out = new MemoryCacheImageOutputStream(deflater);
                    this.writeEpilog();
                    this.out.close();
                    deflater.close();
                    if ((long)((ByteArrayOutputStream)buf).size() <= headerSize + freeSize || --maxIteration <= 0) break;
                    if (headerSize != 0L) {
                        freeSize = Math.max(freeSize, (long)((ByteArrayOutputStream)buf).size() - headerSize - freeSize);
                    }
                    headerSize = ((ByteArrayOutputStream)buf).size();
                }
                freeSize = headerSize + freeSize - (long)((ByteArrayOutputStream)buf).size();
                headerSize = ((ByteArrayOutputStream)buf).size();
                if (maxIteration < 0 || ((ByteArrayOutputStream)buf).size() == 0) {
                    compressHeader = false;
                    System.err.println("WARNING QuickTimeWriter failed to compress header.");
                } else {
                    this.out = new FileImageOutputStream(outputFile);
                    this.writeProlog();
                    DataAtomOutputStream daos = new DataAtomOutputStream(new ImageOutputStreamAdapter(this.out));
                    daos.writeUInt(headerSize + 40L);
                    daos.writeType("moov");
                    daos.writeUInt(headerSize + 32L);
                    daos.writeType("cmov");
                    daos.writeUInt(12L);
                    daos.writeType("dcom");
                    daos.writeType("zlib");
                    daos.writeUInt(headerSize + 12L);
                    daos.writeType("cmvd");
                    daos.writeUInt(originalMoovAtom.size());
                    daos.write(((ByteArrayOutputStream)buf).toByteArray());
                    daos.writeUInt(freeSize + 8L);
                    daos.writeType("free");
                    int i = 0;
                    while ((long)i < freeSize) {
                        daos.write(0);
                        ++i;
                    }
                }
            }
            if (!compressHeader) {
                this.out = new FileImageOutputStream(outputFile);
                this.mdatOffset = this.moovAtom.size();
                this.writeProlog();
                this.writeEpilog();
            }
            buf = new byte[4096];
            originalOut.seek(originalMdatOffset);
            long n = this.mdatAtom.size();
            for (long count = 0L; count < n; count += (long)read) {
                read = originalOut.read((byte[])buf, 0, (int)Math.min((long)((Object)buf).length, n - count));
                this.out.write((byte[])buf, 0, read);
            }
            this.out.close();
        }
        finally {
            this.mdatOffset = 0L;
            this.moovAtom = originalMoovAtom;
            this.out = originalOut;
        }
    }
}

