/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.local;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import nintaco.util.CollectionsUtil;
import nintaco.util.StringUtil;

public class JarClassLoader
extends URLClassLoader {
    private static final Class[] mainArgs = new Class[]{String[].class};
    private final URL url;

    public JarClassLoader(String fileName) throws Throwable {
        this(Paths.get(fileName, new String[0]));
    }

    public JarClassLoader(Path path) throws Throwable {
        this(path.toUri().toURL());
    }

    public JarClassLoader(File file) throws Throwable {
        this(file.toURI().toURL());
    }

    public JarClassLoader(URL url) {
        super(new URL[]{url});
        this.url = url;
    }

    public String[] getMainClassNames() throws Throwable {
        ArrayList<String> classNames = new ArrayList<String>();
        try (JarInputStream in = new JarInputStream(this.url.openStream());){
            JarEntry entry = null;
            while ((entry = in.getNextJarEntry()) != null) {
                String className = this.getMainClassName(entry.getName());
                if (className == null) continue;
                classNames.add(className);
            }
        }
        String defaultClassName = this.getDefaultMainClassName();
        if (defaultClassName != null && classNames.contains(defaultClassName)) {
            classNames.remove(defaultClassName);
            classNames.add(0, defaultClassName);
        }
        return (String[])CollectionsUtil.convertToArray(classNames);
    }

    private String getMainClassName(String entryName) {
        if (entryName != null && entryName.endsWith(".class")) {
            String result = entryName.substring(0, entryName.length() - 6).replaceAll("/", ".");
            if (result.isEmpty() || result.endsWith(".") || !this.isMainClass(result)) {
                return null;
            }
            return result;
        }
        return null;
    }

    private boolean isMainClass(String className) {
        try {
            Method m = this.loadClass(className).getMethod("main", mainArgs);
            m.setAccessible(true);
            int modifiers = m.getModifiers();
            if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultMainClassName() throws IOException {
        JarURLConnection connection = null;
        try {
            connection = (JarURLConnection)new URL("jar", "", this.url + "!/").openConnection();
            Attributes attr = connection.getMainAttributes();
            String className = attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
            String string = StringUtil.isBlank(className) ? null : className;
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.getJarFile().close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void runMain(String className, String[] arguments) throws Throwable {
        Method m = this.loadClass(className).getMethod("main", mainArgs);
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        m.invoke(null, new Object[]{arguments});
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (URL url : this.getURLs()) {
            if (!"jar".equals(url.getProtocol())) continue;
            try {
                ((JarURLConnection)url.openConnection()).getJarFile().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

