/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DataStream {
    public static final int ARRAY_LENGTH = 1024;
    private final DataOutputStream out;
    private final DataInputStream in;

    public DataStream(DataOutputStream out, DataInputStream in) {
        this.out = out;
        this.in = in;
    }

    public void writeByte(int value) throws Throwable {
        this.out.writeByte(value);
    }

    public int readByte() throws Throwable {
        return this.in.readUnsignedByte();
    }

    public void writeInt(int value) throws Throwable {
        this.out.writeInt(value);
    }

    public int readInt() throws Throwable {
        return this.in.readInt();
    }

    public void writeIntArray(int[] array) throws Throwable {
        this.out.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.out.writeInt(array[i]);
        }
    }

    public int readIntArray(int[] array) throws Throwable {
        int length = this.in.readInt();
        if (length < 0 || length > array.length) {
            this.in.close();
            this.out.close();
            throw new IOException("Invalid array length: " + length);
        }
        for (int i = 0; i < length; ++i) {
            array[i] = this.in.readInt();
        }
        return length;
    }

    public void writeBoolean(boolean value) throws Throwable {
        this.out.writeBoolean(value);
    }

    public boolean readBoolean() throws Throwable {
        return this.in.readBoolean();
    }

    public void writeChar(char value) throws Throwable {
        this.out.writeByte(value);
    }

    public char readChar() throws Throwable {
        return (char)this.in.readUnsignedByte();
    }

    public void writeCharArray(char[] array) throws Throwable {
        this.out.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.out.writeByte(array[i]);
        }
    }

    public int readCharArray(char[] array) throws Throwable {
        int length = this.in.readInt();
        if (length < 0 || length > array.length) {
            this.in.close();
            this.out.close();
            throw new IOException("Invalid array length: " + length);
        }
        for (int i = 0; i < length; ++i) {
            array[i] = (char)this.in.readUnsignedByte();
        }
        return length;
    }

    public void writeString(String value) throws Throwable {
        int length = value.length();
        this.out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            this.out.writeByte(value.charAt(i));
        }
    }

    public String readString() throws Throwable {
        int length = this.in.readInt();
        if (length < 0 || length > 1024) {
            this.in.close();
            this.out.close();
            throw new IOException("Invalid array length: " + length);
        }
        char[] cs = new char[length];
        for (int i = 0; i < length; ++i) {
            cs[i] = (char)this.in.readUnsignedByte();
        }
        return new String(cs);
    }

    public void writeStringArray(String[] array) throws Throwable {
        this.out.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeString(array[i]);
        }
    }

    public int readStringArray(String[] array) throws Throwable {
        int length = this.in.readInt();
        if (length < 0 || length > array.length) {
            this.in.close();
            this.out.close();
            throw new IOException("Invalid array length: " + length);
        }
        for (int i = 0; i < length; ++i) {
            array[i] = this.readString();
        }
        return length;
    }

    public String[] readDynamicStringArray() throws Throwable {
        int length = this.in.readInt();
        if (length < 0 || length > 1024) {
            this.in.close();
            this.out.close();
            throw new IOException("Invalid array length: " + length);
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readString();
        }
        return array;
    }

    public void flush() throws Throwable {
        this.out.flush();
    }
}

