/*
 * Decompiled with CFR 0.152.
 */
package nintaco.cartdb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.HashMap;
import java.util.Map;
import nintaco.cartdb.Cart;
import nintaco.tv.TVSystem;

public final class CartDB {
    private static final Map<Integer, Cart> carts = new HashMap<Integer, Cart>();
    private static volatile boolean enabled = true;

    public static void init() {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(CartDB.class.getResourceAsStream("/nintaco/cartdb/cart-db.dat")));
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        int crc = in.readInt();
                        int mapper = in.readUnsignedByte();
                        int submapper = in.readUnsignedByte();
                        mapper |= (submapper & 0xC0) << 2;
                        TVSystem tvSystem = CartDB.getTVSystem(in.readUnsignedByte());
                        byte device = in.readByte();
                        byte mirroring = in.readByte();
                        carts.put(crc, new Cart(crc, mapper, submapper &= 0x3F, tvSystem, device, mirroring, CartDB.isLagButtons(crc)));
                    }
                }
                catch (EOFException eof) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            in.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isLagButtons(int crc) {
        switch (crc) {
            case -810639878: 
            case 180213194: {
                return true;
            }
            case -1606025699: 
            case -1268616818: 
            case -859114648: 
            case 86441741: 
            case 1659858041: 
            case 1880264379: {
                return true;
            }
        }
        return false;
    }

    private static TVSystem getTVSystem(int tvSystem) {
        switch (tvSystem) {
            case 0: {
                return TVSystem.NTSC;
            }
            case 1: {
                return TVSystem.PAL;
            }
        }
        return TVSystem.Dendy;
    }

    public static synchronized Cart getCart(int crc) {
        return carts.get(crc);
    }

    public static synchronized void setEnabled(boolean enabled) {
        CartDB.enabled = enabled;
    }

    public static synchronized boolean isEnabled() {
        return enabled;
    }

    private CartDB() {
    }
}

