/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files.vs.mame;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import nintaco.files.ArchiveEntry;
import nintaco.files.FileUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.StreamUtil;

public final class MameFileUtil {
    private static final String HDR_PATH = "/nintaco/files/vs/hdr/";
    private static final String ENTRIES = "entries.txt";
    private static final String PAD_8K = "pad.8k";
    private static final byte[] PAD_8K_DATA = new byte[8192];
    private static final int GUMSHOE_ID = 40;
    private static final ArchiveEntry[][] archiveEntries;
    private static final Set<ArchiveEntry>[] patterns;

    public static int identifyArchive(List<ArchiveEntry> archiveEntries) {
        int i;
        if (CollectionsUtil.isBlank(archiveEntries)) {
            return -1;
        }
        HashSet<ArchiveEntry> entries = new HashSet<ArchiveEntry>();
        for (i = archiveEntries.size() - 1; i >= 0; --i) {
            ArchiveEntry entry = archiveEntries.get(i);
            entries.add(new ArchiveEntry(FileUtil.getFileName(entry.getName()).trim().toLowerCase(Locale.ENGLISH), entry.getSize()));
        }
        for (i = patterns.length - 1; i >= 0; --i) {
            if (!entries.containsAll(patterns[i])) continue;
            return i;
        }
        return -1;
    }

    public static void getArchiveInputStream(String archiveFileName, List<ArchiveEntry> allEntries, int archiveID, FileUtil.InputStreamListener listener) throws Throwable {
        ArchiveEntry[] entries = archiveEntries[archiveID];
        String[] files = new String[entries.length];
        block0: for (int i = allEntries.size() - 1; i >= 0; --i) {
            ArchiveEntry _entry = allEntries.get(i);
            ArchiveEntry entry = new ArchiveEntry(FileUtil.getFileName(_entry.getName()).trim().toLowerCase(Locale.ENGLISH), _entry.getSize());
            for (int j = entries.length - 1; j > 0; --j) {
                if (!entries[j].equals(entry)) continue;
                files[j] = _entry.getName();
                continue block0;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        StreamUtil.copy(MameFileUtil.class.getResourceAsStream(HDR_PATH + entries[0].getName()), out, buffer);
        for (int i = 1; i < entries.length; ++i) {
            if (PAD_8K.equals(entries[i].getName())) {
                out.write(PAD_8K_DATA);
                continue;
            }
            FileUtil.getArchiveInputStream(archiveFileName, files[i], (in, fileSize) -> StreamUtil.copy(in, out, buffer), null);
        }
        out.close();
        byte[] data = out.toByteArray();
        if (archiveID == 40) {
            System.arraycopy(data, 8208, buffer, 0, 8192);
            System.arraycopy(data, 16400, data, 8208, 24576);
            System.arraycopy(buffer, 0, data, 32784, 8192);
        }
        listener.handleInputStream(new ByteArrayInputStream(data), data.length);
    }

    private MameFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Arrays.fill(PAD_8K_DATA, (byte)-1);
        ArchiveEntry[][] entries = null;
        try {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(MameFileUtil.class.getResourceAsStream(ENTRIES)));){
                int archives = Integer.parseInt(br.readLine());
                entries = new ArchiveEntry[archives][];
                for (int i = 0; i < archives; ++i) {
                    int archiveLength = Integer.parseInt(br.readLine());
                    entries[i] = new ArchiveEntry[archiveLength];
                    ArchiveEntry[] es = entries[i];
                    for (int j = 0; j < archiveLength; ++j) {
                        es[j] = new ArchiveEntry(br.readLine(), Long.parseLong(br.readLine()));
                    }
                }
            }
            archiveEntries = entries;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                archiveEntries = entries;
            }
            catch (Throwable throwable) {
                archiveEntries = entries;
                patterns = new Set[archiveEntries.length];
                for (int i = patterns.length - 1; i >= 0; --i) {
                    MameFileUtil.patterns[i] = new HashSet<ArchiveEntry>();
                    HashSet<ArchiveEntry> set = MameFileUtil.patterns[i];
                    ArchiveEntry[] es = archiveEntries[i];
                    for (int j = es.length - 1; j > 0; --j) {
                        ArchiveEntry entry = es[j];
                        if (PAD_8K.equals(entry.getName())) continue;
                        set.add(entry);
                    }
                }
                throw throwable;
            }
            patterns = new Set[archiveEntries.length];
            for (int i = patterns.length - 1; i >= 0; --i) {
                MameFileUtil.patterns[i] = new HashSet<ArchiveEntry>();
                HashSet<ArchiveEntry> set = MameFileUtil.patterns[i];
                ArchiveEntry[] es = archiveEntries[i];
                for (int j = es.length - 1; j > 0; --j) {
                    ArchiveEntry entry = es[j];
                    if (PAD_8K.equals(entry.getName())) continue;
                    set.add(entry);
                }
            }
        }
        patterns = new Set[archiveEntries.length];
        for (int i = patterns.length - 1; i >= 0; --i) {
            MameFileUtil.patterns[i] = new HashSet<ArchiveEntry>();
            HashSet<ArchiveEntry> set = MameFileUtil.patterns[i];
            ArchiveEntry[] es = archiveEntries[i];
            for (int j = es.length - 1; j > 0; --j) {
                ArchiveEntry entry = es[j];
                if (PAD_8K.equals(entry.getName())) continue;
                set.add(entry);
            }
        }
    }
}

