/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.files.Console;
import nintaco.files.ExtendedConsole;
import nintaco.files.MutableNesFile;
import nintaco.files.NesFile;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.preferences.Paths;
import nintaco.mappers.nintendo.vs.VsHardware;
import nintaco.mappers.nintendo.vs.VsPPU;
import nintaco.preferences.AppPrefs;
import nintaco.util.BitUtil;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;
import nintaco.util.StringUtil;

public class EditNesHeaderDialog
extends JDialog {
    private static final String[] MEM_SIZES_16 = new String[]{"None", "16K", "32K", "64K", "128K", "256K", "512K", "1M", "2M", "4M", "8M", "16M", "32M", "64M"};
    private static final String[] MEM_SIZES_8 = new String[]{"None", "8K", "16K", "32K", "64K", "128K", "256K", "512K", "1M", "2M", "4M", "8M", "16M", "32M"};
    private static final String[] RAM_SIZES = new String[]{"None", "128", "256", "512", "1K", "2K", "4K", "8K", "16K", "32K", "64K", "128K", "256K", "512K", "1M"};
    private final ItemListener itemListener = this::selectionChanged;
    private MutableNesFile originalNesFile;
    private MutableNesFile nesFile;
    private File saveFile;
    private String entryFileName;
    private JButton CancelButton;
    private JButton RestoreAllButton;
    private JPanel bottomPanel;
    private JComboBox chrNVRamComboBox;
    private JLabel chrNVRamLabel;
    private JComboBox chrRamComboBox;
    private JLabel chrRamLabel;
    private JComboBox chrRomComboBox;
    private JLabel chrRomLabel;
    private JComboBox<String> consoleComboBox;
    private JLabel consoleLabel;
    private ButtonGroup fileFormatButtonGroup;
    private JLabel fileFormatLabel;
    private JRadioButton fourScreenRadioButton;
    private JRadioButton horizontalRadioButton;
    private JRadioButton iNESRadioButton;
    private JPanel leftPanel;
    private ButtonGroup machineButtonGroup;
    private JLabel mapperLabel;
    private JTextField mapperTextField;
    private JPanel middlePanel;
    private ButtonGroup mirroringButtonGroup;
    private JLabel mirroringLabel;
    private JComboBox<String> miscROMsComboBox;
    private JLabel miscROMsLabel;
    private JRadioButton nes20RadioButton;
    private JComboBox<String> peripheralComboBox;
    private JLabel peripheralLabel;
    private JComboBox prgNVRamComboBox;
    private JLabel prgNVRamLabel;
    private JComboBox prgRamComboBox;
    private JLabel prgRamLabel;
    private JComboBox prgRomComboBox;
    private JLabel prgRomLabel;
    private JPanel rightPanel;
    private JButton saveAsButton;
    private JLabel submapperLabel;
    private JTextField submapperTextField;
    private JPanel topPanel;
    private JCheckBox trainerCheckBox;
    private ButtonGroup tvSystemButtonGroup;
    private JComboBox<String> tvSystemComboBox;
    private JLabel tvSystemLabel;
    private JRadioButton verticalRadioButton;
    private JComboBox vsHardwareComboBox;
    private JLabel vsHardwareLabel;
    private JComboBox vsPPUComboBox;
    private JLabel vsPPULabel;

    public EditNesHeaderDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.saveAsButton);
        this.prgRomComboBox.setPrototypeDisplayValue("None ");
        this.prgRamComboBox.setPrototypeDisplayValue("None ");
        this.prgNVRamComboBox.setPrototypeDisplayValue("Disabled ");
        this.chrRomComboBox.setPrototypeDisplayValue("None ");
        this.chrRamComboBox.setPrototypeDisplayValue("None ");
        this.chrNVRamComboBox.setPrototypeDisplayValue("None ");
        this.miscROMsComboBox.setPrototypeDisplayValue("0 ");
        this.tvSystemComboBox.setPrototypeDisplayValue("Multi-region ");
        this.consoleComboBox.setPrototypeDisplayValue(ExtendedConsole.toString(4) + " ");
        this.peripheralComboBox.setPrototypeDisplayValue(NesFile.DefaultExpansionDevice.toString(39) + " ");
        this.vsPPUComboBox.setPrototypeDisplayValue(VsPPU.toString(5) + " ");
        this.vsHardwareComboBox.setPrototypeDisplayValue(VsHardware.toString(6) + " ");
        GuiUtil.scaleFonts(this);
        this.pack();
    }

    public void setEntryFileName(String entryFileName) {
        this.entryFileName = entryFileName;
    }

    public void setNesFile(MutableNesFile nesFile) {
        this.originalNesFile = nesFile;
        this.restoreAllFields();
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public MutableNesFile getNesFile() {
        return this.nesFile;
    }

    private void restoreAllFields() {
        this.nesFile = this.originalNesFile.copy();
        this.setAllFields();
    }

    private void captureAllFields() {
        this.nesFile.setNes20Format(this.nes20RadioButton.isSelected());
        this.nesFile.setMapperNumber(MathUtil.clamp(StringUtil.parseInt(this.mapperTextField.getText()), 0, 4095));
        this.nesFile.setSubmapperNumber(MathUtil.clamp(StringUtil.parseInt(this.submapperTextField.getText()), 0, 15));
        if (this.horizontalRadioButton.isSelected()) {
            this.nesFile.setMirroring(1);
        } else if (this.verticalRadioButton.isSelected()) {
            this.nesFile.setMirroring(0);
        } else if (this.fourScreenRadioButton.isSelected()) {
            this.nesFile.setMirroring(4);
        }
        if (this.prgRomComboBox.getSelectedIndex() == 0) {
            this.nesFile.setPrgRomPages(0);
        } else {
            this.nesFile.setPrgRomPages(MathUtil.clamp(1 << this.prgRomComboBox.getSelectedIndex() - 1, 0, this.nes20RadioButton.isSelected() ? 3839 : 255));
        }
        if (this.chrRomComboBox.getSelectedIndex() == 0) {
            this.nesFile.setChrRomPages(0);
        } else {
            this.nesFile.setChrRomPages(MathUtil.clamp(1 << this.chrRomComboBox.getSelectedIndex() - 1, 0, this.nes20RadioButton.isSelected() ? 3839 : 255));
        }
        if (this.prgNVRamComboBox.getModel().getSize() == 2) {
            this.nesFile.setNonVolatilePrgRamPresent(this.prgNVRamComboBox.getSelectedIndex() == 1);
            this.nesFile.setNonVolatilePrgRamSize(this.nesFile.isNonVolatilePrgRamPresent() ? 8192 : 0);
        } else if (this.prgNVRamComboBox.getSelectedIndex() == 0) {
            this.nesFile.setNonVolatilePrgRamSize(0);
            this.nesFile.setNonVolatilePrgRamPresent(false);
        } else {
            this.nesFile.setNonVolatilePrgRamSize(1 << this.prgNVRamComboBox.getSelectedIndex() + 6);
            this.nesFile.setNonVolatilePrgRamPresent(true);
        }
        if (this.chrNVRamComboBox.getModel().getSize() > 0) {
            if (this.chrNVRamComboBox.getSelectedIndex() == 0) {
                this.nesFile.setNonVolatileChrRamSize(0);
            } else {
                this.nesFile.setNonVolatileChrRamSize(1 << this.chrNVRamComboBox.getSelectedIndex() + 6);
            }
        }
        if (this.chrRamComboBox.getModel().getSize() > 0) {
            if (this.chrRamComboBox.getSelectedIndex() == 0) {
                this.nesFile.setChrRamSize(0);
            } else {
                this.nesFile.setChrRamSize(1 << this.chrRamComboBox.getSelectedIndex() + 6);
            }
        }
        if (this.prgRamComboBox.getSelectedIndex() == 0) {
            this.nesFile.setPrgRamPages(0);
            this.nesFile.setPrgRamSize(0);
        } else if (this.prgRamComboBox.getModel().getSize() == 10) {
            this.nesFile.setPrgRamPages(1 << this.prgRamComboBox.getSelectedIndex() - 1);
            this.nesFile.setPrgRamSize(this.nesFile.getPrgRamPages() * 8192);
        } else {
            this.nesFile.setPrgRamSize(1 << this.prgRamComboBox.getSelectedIndex() + 6);
            this.nesFile.setPrgRamPages(this.nesFile.getPrgRamSize() / 8192);
        }
        if (this.miscROMsComboBox.getModel().getSize() > 0) {
            this.nesFile.setMiscellaneousROMs(this.miscROMsComboBox.getSelectedIndex());
        }
        switch (this.tvSystemComboBox.getSelectedIndex()) {
            case 1: {
                this.nesFile.setCpuPpuTiming(1);
                break;
            }
            case 2: {
                this.nesFile.setCpuPpuTiming(3);
                break;
            }
            case 3: {
                this.nesFile.setCpuPpuTiming(2);
                break;
            }
            default: {
                this.nesFile.setCpuPpuTiming(0);
            }
        }
        this.nesFile.setConsole(Math.min(this.consoleComboBox.getSelectedIndex(), 3));
        this.nesFile.setExtendedConsole(this.consoleComboBox.getSelectedIndex());
        if (this.peripheralComboBox.getModel().getSize() > 0) {
            this.nesFile.setDefaultExpansionDevice(this.peripheralComboBox.getSelectedIndex());
        }
        if (this.vsHardwareComboBox.getModel().getSize() > 0) {
            this.nesFile.setVsHardware(this.vsHardwareComboBox.getSelectedIndex());
        }
        if (this.vsPPUComboBox.getModel().getSize() > 0) {
            this.nesFile.setVsPPU(this.vsPPUComboBox.getSelectedIndex());
        }
        this.nesFile.setTrainerPresent(this.trainerCheckBox.isSelected());
    }

    private void setMemSizes(JComboBox comboBox, String[] romSizes, int romLength, int origin) {
        int len;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int n = len = this.nesFile.isNes20Format() ? 14 : 10;
        for (int i = 0; i < len; ++i) {
            model.addElement(romSizes[i]);
        }
        comboBox.setModel(model);
        comboBox.setSelectedIndex(MathUtil.clamp(BitUtil.log2(BitUtil.ceilBase2(romLength)) - origin, 0, model.getSize() - 1));
    }

    private void setMemSizes(JComboBox comboBox, int size) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(RAM_SIZES);
        comboBox.setModel(model);
        comboBox.setSelectedIndex(MathUtil.clamp(size == 0 ? 0 : BitUtil.log2(size) - 6, 0, model.getSize() - 1));
    }

    private void setAllFields() {
        int i;
        DefaultComboBoxModel<String> model;
        this.nes20RadioButton.removeItemListener(this.itemListener);
        this.iNESRadioButton.removeItemListener(this.itemListener);
        this.consoleComboBox.removeItemListener(this.itemListener);
        this.setMemSizes(this.prgRomComboBox, MEM_SIZES_16, this.nesFile.getPrgRomLength(), 13);
        this.setMemSizes(this.chrRomComboBox, MEM_SIZES_8, this.nesFile.getChrRomLength(), 12);
        if (this.nesFile.isNes20Format() && this.nesFile.isVsSystem()) {
            model = new DefaultComboBoxModel<String>();
            for (i = 0; i < 4; ++i) {
                model.addElement(VsHardware.toString(i));
            }
            this.vsHardwareComboBox.setEnabled(true);
            this.vsHardwareComboBox.setModel(model);
            this.setSelectedIndex(this.vsHardwareComboBox, this.nesFile.getVsHardware());
            model = new DefaultComboBoxModel();
            for (i = 0; i < 13; ++i) {
                model.addElement(VsPPU.toString(i));
            }
            this.vsPPUComboBox.setEnabled(true);
            this.vsPPUComboBox.setModel(model);
            this.setSelectedIndex(this.vsPPUComboBox, this.nesFile.getVsPPU());
        } else {
            this.vsHardwareComboBox.setEnabled(false);
            this.vsHardwareComboBox.setModel(new DefaultComboBoxModel());
            this.vsPPUComboBox.setEnabled(false);
            this.vsPPUComboBox.setModel(new DefaultComboBoxModel());
        }
        if (this.nesFile.isNes20Format()) {
            this.nes20RadioButton.setSelected(true);
            this.submapperTextField.setText(Integer.toString(this.nesFile.getSubmapperNumber()));
            this.submapperTextField.setEnabled(true);
            this.chrRamComboBox.setEnabled(true);
            this.chrNVRamComboBox.setEnabled(true);
            this.setMemSizes(this.prgNVRamComboBox, this.nesFile.getNonVolatilePrgRamSize());
            this.setMemSizes(this.chrRamComboBox, this.nesFile.getChrRamSize());
            this.setMemSizes(this.chrNVRamComboBox, this.nesFile.getNonVolatileChrRamSize());
            this.setMemSizes(this.prgRamComboBox, this.nesFile.getPrgRamSize());
            this.tvSystemComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"NTSC", "PAL", "Dendy", "Multi-region"}));
            switch (this.nesFile.getCpuPpuTiming()) {
                case 0: {
                    this.tvSystemComboBox.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.tvSystemComboBox.setSelectedIndex(1);
                    break;
                }
                case 3: {
                    this.tvSystemComboBox.setSelectedIndex(2);
                    break;
                }
                case 2: {
                    this.tvSystemComboBox.setSelectedIndex(3);
                }
            }
            this.consoleComboBox.setModel(new DefaultComboBoxModel<String>(ExtendedConsole.NAMES));
            this.setSelectedIndex(this.consoleComboBox, this.nesFile.getConsole() == 3 ? this.nesFile.getExtendedConsole() : this.nesFile.getConsole());
            this.peripheralComboBox.setEnabled(true);
            this.peripheralComboBox.setModel(new DefaultComboBoxModel<String>(NesFile.DefaultExpansionDevice.NAMES));
            this.setSelectedIndex(this.peripheralComboBox, this.nesFile.getDefaultExpansionDevice());
            this.miscROMsComboBox.setEnabled(true);
            this.miscROMsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3"}));
            this.setSelectedIndex(this.miscROMsComboBox, this.nesFile.getMiscellaneousROMs());
        } else {
            this.iNESRadioButton.setSelected(true);
            this.submapperTextField.setText("");
            this.submapperTextField.setEnabled(false);
            this.chrRamComboBox.setEnabled(false);
            this.chrNVRamComboBox.setEnabled(false);
            this.chrRamComboBox.setModel(new DefaultComboBoxModel());
            this.chrNVRamComboBox.setModel(new DefaultComboBoxModel());
            this.prgNVRamComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Disabled", "Enabled"}));
            this.setSelectedIndex(this.prgNVRamComboBox, this.nesFile.isNonVolatilePrgRamPresent() ? 1 : 0);
            this.setMemSizes(this.prgRamComboBox, MEM_SIZES_8, this.nesFile.getPrgRamSize(), 12);
            this.tvSystemComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"NTSC", "PAL"}));
            this.setSelectedIndex(this.tvSystemComboBox, this.nesFile.getCpuPpuTiming() == 1 ? 1 : 0);
            model = new DefaultComboBoxModel();
            for (i = 0; i < 3; ++i) {
                model.addElement(Console.NAMES[i]);
            }
            this.consoleComboBox.setModel(model);
            this.setSelectedIndex(this.consoleComboBox, this.nesFile.getConsole() == 3 ? 0 : this.nesFile.getConsole());
            this.peripheralComboBox.setEnabled(false);
            this.peripheralComboBox.setModel(new DefaultComboBoxModel());
            this.miscROMsComboBox.setEnabled(false);
            this.miscROMsComboBox.setModel(new DefaultComboBoxModel());
        }
        this.mapperTextField.setText(Integer.toString(this.nesFile.getMapperNumber()));
        switch (this.nesFile.getMirroring()) {
            case 1: {
                this.horizontalRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.verticalRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.fourScreenRadioButton.setSelected(true);
            }
        }
        this.trainerCheckBox.setSelected(this.nesFile.isTrainerPresent());
        this.nes20RadioButton.addItemListener(this.itemListener);
        this.iNESRadioButton.addItemListener(this.itemListener);
        this.consoleComboBox.addItemListener(this.itemListener);
    }

    private void setSelectedIndex(JComboBox comboBox, int index) {
        comboBox.setSelectedIndex(index < 0 || index >= comboBox.getModel().getSize() ? 0 : index);
    }

    private void selectionChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            EventQueue.invokeLater(() -> {
                this.captureAllFields();
                this.setAllFields();
            });
        }
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.fileFormatButtonGroup = new ButtonGroup();
        this.mirroringButtonGroup = new ButtonGroup();
        this.tvSystemButtonGroup = new ButtonGroup();
        this.machineButtonGroup = new ButtonGroup();
        this.bottomPanel = new JPanel();
        this.CancelButton = new JButton();
        this.RestoreAllButton = new JButton();
        this.saveAsButton = new JButton();
        this.topPanel = new JPanel();
        this.leftPanel = new JPanel();
        this.mirroringLabel = new JLabel();
        this.fourScreenRadioButton = new JRadioButton();
        this.iNESRadioButton = new JRadioButton();
        this.fileFormatLabel = new JLabel();
        this.nes20RadioButton = new JRadioButton();
        this.horizontalRadioButton = new JRadioButton();
        this.mapperTextField = new JTextField();
        this.submapperLabel = new JLabel();
        this.verticalRadioButton = new JRadioButton();
        this.mapperLabel = new JLabel();
        this.submapperTextField = new JTextField();
        this.middlePanel = new JPanel();
        this.prgRomLabel = new JLabel();
        this.prgRomComboBox = new JComboBox();
        this.prgRamLabel = new JLabel();
        this.prgRamComboBox = new JComboBox();
        this.prgNVRamLabel = new JLabel();
        this.prgNVRamComboBox = new JComboBox();
        this.chrRomLabel = new JLabel();
        this.chrRamLabel = new JLabel();
        this.chrNVRamLabel = new JLabel();
        this.chrNVRamComboBox = new JComboBox();
        this.chrRamComboBox = new JComboBox();
        this.chrRomComboBox = new JComboBox();
        this.miscROMsLabel = new JLabel();
        this.miscROMsComboBox = new JComboBox();
        this.rightPanel = new JPanel();
        this.consoleLabel = new JLabel();
        this.vsPPULabel = new JLabel();
        this.vsPPUComboBox = new JComboBox();
        this.vsHardwareLabel = new JLabel();
        this.vsHardwareComboBox = new JComboBox();
        this.tvSystemLabel = new JLabel();
        this.tvSystemComboBox = new JComboBox();
        this.consoleComboBox = new JComboBox();
        this.peripheralLabel = new JLabel();
        this.peripheralComboBox = new JComboBox();
        this.trainerCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("iNES File Header Editor");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditNesHeaderDialog.this.formWindowClosing(evt);
            }
        });
        this.bottomPanel.setPreferredSize(null);
        this.CancelButton.setMnemonic('C');
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditNesHeaderDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.RestoreAllButton.setMnemonic('R');
        this.RestoreAllButton.setText("Restore All");
        this.RestoreAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditNesHeaderDialog.this.RestoreAllButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setMnemonic('S');
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditNesHeaderDialog.this.saveAsButtonActionPerformed(evt);
            }
        });
        GroupLayout bottomPanelLayout = new GroupLayout(this.bottomPanel);
        this.bottomPanel.setLayout(bottomPanelLayout);
        bottomPanelLayout.setHorizontalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bottomPanelLayout.createSequentialGroup().addGap(0, 167, Short.MAX_VALUE).addComponent(this.saveAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RestoreAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addGap(0, 0, 0)));
        bottomPanelLayout.linkSize(0, this.CancelButton, this.RestoreAllButton, this.saveAsButton);
        bottomPanelLayout.setVerticalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bottomPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.RestoreAllButton).addComponent(this.saveAsButton)).addContainerGap()));
        this.topPanel.setPreferredSize(null);
        this.leftPanel.setPreferredSize(null);
        this.leftPanel.setLayout(new GridBagLayout());
        this.mirroringLabel.setText("Mirroring:");
        this.mirroringLabel.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(22, 10, 0, 0);
        this.leftPanel.add((Component)this.mirroringLabel, gridBagConstraints);
        this.mirroringButtonGroup.add(this.fourScreenRadioButton);
        this.fourScreenRadioButton.setText("Four-screen");
        this.fourScreenRadioButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 12, 7);
        this.leftPanel.add((Component)this.fourScreenRadioButton, gridBagConstraints);
        this.fileFormatButtonGroup.add(this.iNESRadioButton);
        this.iNESRadioButton.setSelected(true);
        this.iNESRadioButton.setText("iNES");
        this.iNESRadioButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 10, 0, 0);
        this.leftPanel.add((Component)this.iNESRadioButton, gridBagConstraints);
        this.fileFormatLabel.setText("File Format:");
        this.fileFormatLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.leftPanel.add((Component)this.fileFormatLabel, gridBagConstraints);
        this.fileFormatButtonGroup.add(this.nes20RadioButton);
        this.nes20RadioButton.setText("NES 2.0");
        this.nes20RadioButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.leftPanel.add((Component)this.nes20RadioButton, gridBagConstraints);
        this.mirroringButtonGroup.add(this.horizontalRadioButton);
        this.horizontalRadioButton.setSelected(true);
        this.horizontalRadioButton.setText("Horizontal");
        this.horizontalRadioButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 10, 0, 0);
        this.leftPanel.add((Component)this.horizontalRadioButton, gridBagConstraints);
        this.mapperTextField.setColumns(4);
        this.mapperTextField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 10, 0, 0);
        this.leftPanel.add((Component)this.mapperTextField, gridBagConstraints);
        this.submapperLabel.setText("Submapper:");
        this.submapperLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.leftPanel.add((Component)this.submapperLabel, gridBagConstraints);
        this.mirroringButtonGroup.add(this.verticalRadioButton);
        this.verticalRadioButton.setText("Vertical");
        this.verticalRadioButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.leftPanel.add((Component)this.verticalRadioButton, gridBagConstraints);
        this.mapperLabel.setText("Mapper:");
        this.mapperLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 10, 0, 0);
        this.leftPanel.add((Component)this.mapperLabel, gridBagConstraints);
        this.submapperTextField.setColumns(4);
        this.submapperTextField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.leftPanel.add((Component)this.submapperTextField, gridBagConstraints);
        this.middlePanel.setPreferredSize(null);
        this.middlePanel.setLayout(new GridBagLayout());
        this.prgRomLabel.setText("PRG ROM:");
        this.prgRomLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 10, 0, 0);
        this.middlePanel.add((Component)this.prgRomLabel, gridBagConstraints);
        this.prgRomComboBox.setFocusable(false);
        this.prgRomComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 4, 0, 10);
        this.middlePanel.add((Component)this.prgRomComboBox, gridBagConstraints);
        this.prgRamLabel.setText("PRG RAM:");
        this.prgRamLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.middlePanel.add((Component)this.prgRamLabel, gridBagConstraints);
        this.prgRamComboBox.setFocusable(false);
        this.prgRamComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 10);
        this.middlePanel.add((Component)this.prgRamComboBox, gridBagConstraints);
        this.prgNVRamLabel.setText("PRG NVRAM:");
        this.prgNVRamLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.middlePanel.add((Component)this.prgNVRamLabel, gridBagConstraints);
        this.prgNVRamComboBox.setFocusable(false);
        this.prgNVRamComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 10);
        this.middlePanel.add((Component)this.prgNVRamComboBox, gridBagConstraints);
        this.chrRomLabel.setText("CHR ROM:");
        this.chrRomLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 10, 0, 0);
        this.middlePanel.add((Component)this.chrRomLabel, gridBagConstraints);
        this.chrRamLabel.setText("CHR RAM:");
        this.chrRamLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.middlePanel.add((Component)this.chrRamLabel, gridBagConstraints);
        this.chrNVRamLabel.setText("CHR NVRAM:");
        this.chrNVRamLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.middlePanel.add((Component)this.chrNVRamLabel, gridBagConstraints);
        this.chrNVRamComboBox.setFocusable(false);
        this.chrNVRamComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 10);
        this.middlePanel.add((Component)this.chrNVRamComboBox, gridBagConstraints);
        this.chrRamComboBox.setFocusable(false);
        this.chrRamComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 10);
        this.middlePanel.add((Component)this.chrRamComboBox, gridBagConstraints);
        this.chrRomComboBox.setFocusable(false);
        this.chrRomComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 4, 0, 10);
        this.middlePanel.add((Component)this.chrRomComboBox, gridBagConstraints);
        this.miscROMsLabel.setText("Misc. ROMs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 10, 0, 0);
        this.middlePanel.add((Component)this.miscROMsLabel, gridBagConstraints);
        this.miscROMsComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 4, 0, 10);
        this.middlePanel.add(this.miscROMsComboBox, gridBagConstraints);
        this.rightPanel.setPreferredSize(null);
        this.rightPanel.setLayout(new GridBagLayout());
        this.consoleLabel.setText("Console:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.rightPanel.add((Component)this.consoleLabel, gridBagConstraints);
        this.vsPPULabel.setText("VS PPU:");
        this.vsPPULabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 10, 0, 0);
        this.rightPanel.add((Component)this.vsPPULabel, gridBagConstraints);
        this.vsPPUComboBox.setFocusable(false);
        this.vsPPUComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 4, 0, 0);
        this.rightPanel.add((Component)this.vsPPUComboBox, gridBagConstraints);
        this.vsHardwareLabel.setText("VS Hardware:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.rightPanel.add((Component)this.vsHardwareLabel, gridBagConstraints);
        this.vsHardwareComboBox.setFocusable(false);
        this.vsHardwareComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.rightPanel.add((Component)this.vsHardwareComboBox, gridBagConstraints);
        this.tvSystemLabel.setText("TV System:");
        this.tvSystemLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 10, 0, 0);
        this.rightPanel.add((Component)this.tvSystemLabel, gridBagConstraints);
        this.tvSystemComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.rightPanel.add(this.tvSystemComboBox, gridBagConstraints);
        this.consoleComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.rightPanel.add(this.consoleComboBox, gridBagConstraints);
        this.peripheralLabel.setText("Peripheral:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.rightPanel.add((Component)this.peripheralLabel, gridBagConstraints);
        this.peripheralComboBox.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.rightPanel.add(this.peripheralComboBox, gridBagConstraints);
        this.trainerCheckBox.setText("Trainer");
        this.trainerCheckBox.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 10, 24, 0);
        this.rightPanel.add((Component)this.trainerCheckBox, gridBagConstraints);
        GroupLayout topPanelLayout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.leftPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.middlePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        topPanelLayout.setVerticalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.leftPanel, -1, 211, Short.MAX_VALUE).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE).addComponent(this.middlePanel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bottomPanel, -1, 434, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.topPanel, -1, 424, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.topPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanel, -1, 45, Short.MAX_VALUE).addContainerGap()));
    }

    private void RestoreAllButtonActionPerformed(ActionEvent evt) {
        this.restoreAllFields();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        Paths paths = AppPrefs.getInstance().getPaths();
        File file = GuiUtil.showSaveAsDialog(this, paths.getSaveEditedNesFileDir(), this.entryFileName, "nes", ImageFrame.FileExtensionFilters[1], true);
        if (file != null) {
            this.captureAllFields();
            paths.setSaveEditedNesFileDir(file.getParentFile().getPath());
            AppPrefs.save();
            this.saveFile = file;
            this.closeDialog();
        }
    }
}

