/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.barcodebattler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.input.InputUtil;
import nintaco.input.other.TransferBarcode;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class BarcodeBattlerFrame
extends JFrame {
    private final Random random = new Random();
    private JLabel digitsLabel;
    private JTextField digitsTextField;
    private JButton randomizeButton;
    private JButton transferButton;

    public BarcodeBattlerFrame() {
        this.initComponents();
        GuiUtil.addTextFieldEditListener(this.digitsTextField, this::digitsTextFieldEdited);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void closeFrame() {
        App.destroyBarcodeBattlerFrame();
    }

    public void destroy() {
        this.dispose();
    }

    private void digitsTextFieldEdited() {
        String value = StringUtil.removeWhitespaces(this.digitsTextField.getText());
        if (value.length() != 8 && value.length() != 13) {
            this.transferButton.setEnabled(false);
            return;
        }
        int sum = 0;
        boolean three = false;
        for (int i = value.length() - 1; i >= 0; --i) {
            char ch = value.charAt(i);
            if (ch < '0' || ch > '9') {
                this.transferButton.setEnabled(false);
                return;
            }
            int digit = ch - 48;
            if (three) {
                three = false;
                sum += 3 * digit;
                continue;
            }
            three = true;
            sum += digit;
        }
        this.transferButton.setEnabled(sum % 10 == 0);
    }

    private void transferBarcode(String barcode) {
        if (App.getMachineRunner() != null) {
            InputUtil.addOtherInput(new TransferBarcode(barcode));
        } else {
            InputUtil.setBarcode(null);
        }
    }

    private void initComponents() {
        this.digitsLabel = new JLabel();
        this.digitsTextField = new JTextField();
        this.transferButton = new JButton();
        this.randomizeButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Barcode Battler II");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BarcodeBattlerFrame.this.formWindowClosing(evt);
            }
        });
        this.digitsLabel.setText("Digits");
        this.digitsLabel.setMaximumSize(null);
        this.digitsLabel.setMinimumSize(null);
        this.digitsLabel.setPreferredSize(null);
        this.digitsTextField.setColumns(32);
        this.digitsTextField.setText(" ");
        this.digitsTextField.setMaximumSize(null);
        this.digitsTextField.setMinimumSize(null);
        this.digitsTextField.setPreferredSize(null);
        this.transferButton.setMnemonic('T');
        this.transferButton.setText("Transfer");
        this.transferButton.setEnabled(false);
        this.transferButton.setFocusPainted(false);
        this.transferButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarcodeBattlerFrame.this.transferButtonActionPerformed(evt);
            }
        });
        this.randomizeButton.setMnemonic('R');
        this.randomizeButton.setText("Randomize");
        this.randomizeButton.setFocusPainted(false);
        this.randomizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarcodeBattlerFrame.this.randomizeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.digitsLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.digitsTextField, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 66, Short.MAX_VALUE).addComponent(this.randomizeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transferButton))).addContainerGap()));
        layout.linkSize(0, this.randomizeButton, this.transferButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.digitsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.digitsTextField, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.transferButton).addComponent(this.randomizeButton)).addContainerGap()));
    }

    private void randomizeButtonActionPerformed(ActionEvent evt) {
        int i;
        StringBuilder sb = new StringBuilder();
        int sum = 0;
        boolean three = this.random.nextBoolean();
        int n = i = three ? 6 : 11;
        while (i >= 0) {
            int digit = this.random.nextInt(10);
            sb.append((char)(48 + digit));
            if (three) {
                three = false;
                sum += 3 * digit;
            } else {
                three = true;
                sum += digit;
            }
            --i;
        }
        sb.append((char)(48 + (10 - sum % 10) % 10));
        this.digitsTextField.setText(sb.toString());
    }

    private void transferButtonActionPerformed(ActionEvent evt) {
        this.transferBarcode(StringUtil.removeWhitespaces(this.digitsTextField.getText()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }
}

