/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import nintaco.App;
import nintaco.cheats.Cheat;
import nintaco.cheats.GameCheats;
import nintaco.files.CartFile;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.RadioSelectionDialog;
import nintaco.gui.ToolTipsTable;
import nintaco.gui.cheats.CheatPrefs;
import nintaco.gui.cheats.CheatsTableModel;
import nintaco.gui.cheats.CreateCheatDialog;
import nintaco.gui.cheats.search.CheatSearchFrame;
import nintaco.gui.image.preferences.Paths;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class CheatsDialog
extends JDialog {
    private static final FileExtensionFilter[] FILE_FILTERS = new FileExtensionFilter[]{new FileExtensionFilter(0, "All supported cheat files", "cht", "xml"), new FileExtensionFilter(1, "Cheat text files (*.cht)", "cht"), new FileExtensionFilter(2, "Cheat XML files (*.xml)", "xml"), new FileExtensionFilter(3, "All files (*.*)")};
    final CheatPrefs cheatPrefs;
    private CheatsTableModel tableModel;
    private Cheat newCheat;
    private JButton cancelButton;
    private JScrollPane cheatsScrollPane;
    private JTable cheatsTable;
    private JButton clearButton;
    private JButton deleteButton;
    private JButton editButton;
    private JButton exportButton;
    private JButton importButton;
    private JButton newButton;
    private JButton okButton;
    private JButton resetButton;
    private JCheckBox showHexCheckBox;
    private JPanel tableButtonsPanel;

    public CheatsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initTable();
        this.getRootPane().setDefaultButton(this.okButton);
        this.cheatPrefs = AppPrefs.getInstance().getCheatPrefs();
        this.showHexCheckBox.setSelected(this.cheatPrefs.isShowHex());
        this.resetIfEmpty();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setNewCheat(Cheat newCheat) {
        this.newCheat = newCheat;
    }

    private void initTable() {
        List<Cheat> cheats;
        CheatSearchFrame cheatSearch = App.getCheatSearchFrame();
        List<Cheat> list = cheats = cheatSearch == null ? GameCheats.getCheats() : cheatSearch.getCheats();
        if (cheats == null) {
            cheats = new ArrayList<Cheat>();
        }
        this.tableModel = new CheatsTableModel(cheats);
        this.cheatsTable.setModel(this.tableModel);
        this.cheatsScrollPane.setPreferredSize(null);
        GuiUtil.disableCellBorder(this.cheatsTable);
        GuiUtil.forceNoClearRowSelect(this.cheatsTable);
        this.cheatsTable.getSelectionModel().addListSelectionListener(e -> this.updateButtons());
        this.cheatsTable.setAutoResizeMode(0);
        GuiUtil.resizeCellSizes(this.cheatsTable, false, 15, false, Boolean.TRUE, "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM", "$BBBB", "$BB", "$BB", "MMMMMMMM", "MMMMMMMM");
        ((ToolTipsTable)this.cheatsTable).setColumnToolTips("Enabled", "Description", "Address", "Data Value", "Compare Value", "Game Genie Code", "Pro Action Rocky Code");
        this.updateButtons();
    }

    private void updateButtons() {
        boolean rowSelected = this.cheatsTable.getSelectedRowCount() > 0;
        boolean enabled = this.tableModel.getRowCount() > 0;
        this.editButton.setEnabled(enabled && rowSelected);
        this.deleteButton.setEnabled(enabled && rowSelected);
        this.exportButton.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void importFile(PleaseWaitDialog pleaseWaitDialog, File file) {
        List<Cheat> cheats = null;
        try {
            cheats = file.getName().trim().toLowerCase().endsWith("xml") ? GameCheats.loadXML(file) : GameCheats.loadCHT(file);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pleaseWaitDialog.dispose();
        if (cheats == null) {
            GuiUtil.displayError(this, "Failed to import cheats file.");
        } else if (cheats.isEmpty()) {
            GuiUtil.displayError(this, "The file does not contain any valid cheats.");
        } else {
            List<Cheat> cs = cheats;
            EventQueue.invokeLater(() -> {
                this.tableModel.addCheats(cs, true);
                this.updateButtons();
            });
        }
        App.setNoStepPause(false);
    }

    private void exportFile(PleaseWaitDialog pleaseWaitDialog, File file, boolean chtFile, List<Cheat> cheats) {
        boolean error = false;
        try {
            if (chtFile) {
                GameCheats.saveCHT(file, cheats);
            } else {
                CartFile cartFile = App.getCartFile();
                if (cartFile == null) {
                    GameCheats.saveXML(file, cheats);
                } else {
                    GameCheats.saveXML(file, cheats, true, cartFile.getFileCRC());
                }
            }
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to save cheats file.");
        }
        App.setNoStepPause(false);
    }

    private void resetIfEmpty() {
        if (this.tableModel.getRowCount() == 0) {
            this.resetCheats();
        }
    }

    private boolean tableHasBeenReset() {
        for (int i = this.tableModel.getRowCount() - 1; i >= 0; --i) {
            if (!((Boolean)this.tableModel.getValueAt(i, 0)).booleanValue()) continue;
            return false;
        }
        List<Cheat> cheats = GameCheats.queryCheatsDB();
        if (cheats == null || cheats.size() != this.tableModel.getRowCount()) {
            return false;
        }
        for (int i = cheats.size() - 1; i >= 0; --i) {
            if (cheats.get(i).equals(this.tableModel.getRow(i).getCheat())) continue;
            return false;
        }
        return true;
    }

    private void resetCheats() {
        this.tableModel.clear();
        List<Cheat> cheats = GameCheats.queryCheatsDB();
        if (cheats != null) {
            this.tableModel.addCheats(cheats, false);
            this.tableModel.setModified(false);
        }
        this.updateButtons();
    }

    private void addCheat(Cheat cheat) {
        if (cheat != null) {
            this.tableModel.addCheat(cheat);
            EventQueue.invokeLater(() -> {
                GuiUtil.scrollToBottom(this.cheatsScrollPane);
                this.cheatsTable.getSelectionModel().setSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
            });
        }
    }

    private void initComponents() {
        this.cheatsScrollPane = new JScrollPane();
        this.cheatsTable = new ToolTipsTable();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.tableButtonsPanel = new JPanel();
        this.editButton = new JButton();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.deleteButton = new JButton();
        this.newButton = new JButton();
        this.resetButton = new JButton();
        this.clearButton = new JButton();
        this.showHexCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Cheats");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                CheatsDialog.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CheatsDialog.this.formWindowClosing(evt);
            }
        });
        this.cheatsScrollPane.setVerticalScrollBarPolicy(22);
        this.cheatsScrollPane.setMaximumSize(null);
        this.cheatsScrollPane.setMinimumSize(null);
        this.cheatsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.cheatsTable.setPreferredSize(null);
        this.cheatsScrollPane.setViewportView(this.cheatsTable);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.editButton.setMnemonic('E');
        this.editButton.setText("Edit...");
        this.editButton.setFocusable(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.editButtonActionPerformed(evt);
            }
        });
        this.importButton.setMnemonic('I');
        this.importButton.setText("Import...");
        this.importButton.setFocusable(false);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.importButtonActionPerformed(evt);
            }
        });
        this.exportButton.setMnemonic('x');
        this.exportButton.setText("Export...");
        this.exportButton.setFocusable(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.exportButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText("Delete");
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.newButton.setMnemonic('N');
        this.newButton.setText("New...");
        this.newButton.setFocusable(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.newButtonActionPerformed(evt);
            }
        });
        this.resetButton.setMnemonic('R');
        this.resetButton.setFocusable(false);
        this.resetButton.setLabel("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.clearButton.setMnemonic('r');
        this.clearButton.setText("Clear");
        this.clearButton.setFocusable(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout tableButtonsPanelLayout = new GroupLayout(this.tableButtonsPanel);
        this.tableButtonsPanel.setLayout(tableButtonsPanelLayout);
        tableButtonsPanelLayout.setHorizontalGroup(tableButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableButtonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addGap(0, 0, Short.MAX_VALUE)));
        tableButtonsPanelLayout.linkSize(0, this.clearButton, this.deleteButton, this.editButton, this.exportButton, this.importButton, this.newButton, this.resetButton);
        tableButtonsPanelLayout.setVerticalGroup(tableButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableButtonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(tableButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resetButton).addComponent(this.clearButton)).addGroup(tableButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportButton).addComponent(this.importButton).addComponent(this.deleteButton).addComponent(this.editButton).addComponent(this.newButton))).addGap(0, 0, 0)));
        this.showHexCheckBox.setText("Show hex");
        this.showHexCheckBox.setFocusPainted(false);
        this.showHexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsDialog.this.showHexCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cheatsScrollPane, GroupLayout.Alignment.CENTER, -1, -1, Short.MAX_VALUE).addComponent(this.tableButtonsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.showHexCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.cheatsScrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableButtonsPanel, -2, -1, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.showHexCheckBox).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        CreateCheatDialog dialog = new CreateCheatDialog((Window)this);
        dialog.setTitle("New Cheat");
        dialog.setCheat(null);
        dialog.setVisible(true);
        this.addCheat(dialog.getCheat());
        this.updateButtons();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.cheatsTable.getSelectedRow();
        if (rowIndex >= 0 && rowIndex < this.tableModel.getRowCount()) {
            CreateCheatDialog dialog = new CreateCheatDialog((Window)this);
            dialog.setTitle("Edit Cheat");
            dialog.setCheat(this.tableModel.getCheat(rowIndex));
            dialog.setVisible(true);
            Cheat cheat = dialog.getCheat();
            if (cheat != null) {
                this.tableModel.updateCheat(cheat, rowIndex);
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.cheatsTable.getSelectedRow();
        if (rowIndex >= 0 && rowIndex < this.tableModel.getRowCount()) {
            this.tableModel.deleteCheat(rowIndex);
        }
        this.updateButtons();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Import Cheats", AppPrefs.getInstance().getPaths().getCheatsDir(), (FileFilter[])FILE_FILTERS);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setCheatsDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.importFile(pleaseWaitDialog, selectedFile)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        Paths paths = AppPrefs.getInstance().getPaths();
        RadioSelectionDialog dialog = new RadioSelectionDialog(this, "Select file type:", "Export File", this.cheatPrefs.getExportFileType(), "Cheat text file (.cht)", "Cheat XML file (.xml)");
        dialog.setOkButtonText("Next >");
        dialog.setOkButtonMnemonic('N');
        dialog.setVisible(true);
        if (dialog.isOk()) {
            String extension = dialog.getSelectedIndex() == 0 ? "cht" : "xml";
            File file = GuiUtil.showSaveAsDialog(this, paths.getCheatsDir(), FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) + "." + extension, extension, FILE_FILTERS[dialog.getSelectedIndex() + 1], true);
            if (file != null) {
                String dir = file.getParent();
                paths.addRecentDirectory(dir);
                paths.setCheatsDir(dir);
                AppPrefs.save();
                List<Cheat> cheats = this.tableModel.getCheats();
                PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
                this.cheatPrefs.setExportFileType(dialog.getSelectedIndex());
                new Thread(() -> this.exportFile(pleaseWaitDialog, file, dialog.getSelectedIndex() == 0, cheats)).start();
                pleaseWaitDialog.showAfterDelay();
            } else {
                App.setNoStepPause(false);
            }
        } else {
            App.setNoStepPause(false);
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.tableModel.clear();
        this.updateButtons();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.cheatsTable.isEditing()) {
            this.cheatsTable.getCellEditor().stopCellEditing();
        }
        if (!this.tableModel.isModified() || this.tableHasBeenReset()) {
            this.tableModel.clear();
        }
        GameCheats.setCheats(this.tableModel.getCheats());
        GameCheats.save();
        GameCheats.updateMachine();
        this.cheatPrefs.setShowHex(this.showHexCheckBox.isSelected());
        AppPrefs.save();
        CheatSearchFrame cheatSearch = App.getCheatSearchFrame();
        if (cheatSearch != null) {
            cheatSearch.setCheats(this.tableModel.getCheats());
        }
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void showHexCheckBoxActionPerformed(ActionEvent evt) {
        this.tableModel.setShowHex(this.showHexCheckBox.isSelected());
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.newCheat != null) {
            CreateCheatDialog dialog = new CreateCheatDialog((Window)this);
            dialog.setTitle("New Cheat");
            dialog.setCheat(this.newCheat, 2);
            dialog.setVisible(true);
            this.addCheat(dialog.getCheat());
            this.updateButtons();
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.resetCheats();
    }
}

