/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.addresslabel;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.disassembler.AddressLabel;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class CreateAddressLabelDialog
extends JDialog {
    private DocumentListener bankListener;
    private DocumentListener addressListener;
    private DocumentListener labelListener;
    private DocumentListener commentListener;
    private AddressLabel result;
    private boolean ok;
    private int bank = -1;
    private int address;
    private String label;
    private String comment;
    private JLabel addressLabel;
    private JTextField addressTextField;
    private JLabel bankLabel;
    private JTextField bankTextField;
    private JCheckBox bookmarkCheckBox;
    private JButton cancelButton;
    private JCheckBox codeCheckBox;
    private JLabel commentLabel;
    private JTextArea commentTextArea;
    private JLabel labelLabel;
    private JTextField labelTextField;
    private JButton okButton;
    private JScrollPane scrollPane;

    public CreateAddressLabelDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.createDocumentListeners();
        this.addDocumentListeners();
        this.updateOkButton();
        GuiUtil.scaleFonts(this);
        this.commentTextArea.setFont(this.labelTextField.getFont());
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void selectAddress() {
        this.addressTextField.requestFocus();
        this.addressTextField.selectAll();
    }

    public void selectLabel() {
        this.labelTextField.requestFocus();
        this.labelTextField.selectAll();
    }

    private void createDocumentListeners() {
        this.bankListener = GuiUtil.createDocumentListener(this::bankEdited);
        this.addressListener = GuiUtil.createDocumentListener(this::addressEdited);
        this.labelListener = GuiUtil.createDocumentListener(this::labelEdited);
        this.commentListener = GuiUtil.createDocumentListener(this::commentEdited);
    }

    private void addDocumentListeners() {
        this.bankTextField.getDocument().addDocumentListener(this.bankListener);
        this.addressTextField.getDocument().addDocumentListener(this.addressListener);
        this.labelTextField.getDocument().addDocumentListener(this.labelListener);
        this.commentTextArea.getDocument().addDocumentListener(this.commentListener);
    }

    private void removeDocumentListeners() {
        this.bankTextField.getDocument().removeDocumentListener(this.bankListener);
        this.addressTextField.getDocument().removeDocumentListener(this.addressListener);
        this.labelTextField.getDocument().removeDocumentListener(this.labelListener);
        this.commentTextArea.getDocument().removeDocumentListener(this.commentListener);
    }

    private void bankEdited() {
        this.bank = StringUtil.parseInt(this.bankTextField.getText(), true, 255L);
        if (this.bank < 0) {
            this.bank = -1;
        }
        this.updateOkButton();
    }

    private void addressEdited() {
        this.address = StringUtil.parseInt(this.addressTextField.getText(), true, 65535L);
        this.updateOkButton();
    }

    private void labelEdited() {
        this.label = this.labelTextField.getText().trim();
        if (this.label.isEmpty()) {
            this.label = null;
        }
        this.updateOkButton();
    }

    private void commentEdited() {
        this.comment = this.commentTextArea.getText().trim();
        if (this.comment.isEmpty()) {
            this.comment = null;
        }
        this.updateOkButton();
    }

    private void updateOkButton() {
        boolean labelBlank = StringUtil.isBlank(this.label);
        this.okButton.setEnabled(!(this.address < 0 || labelBlank && StringUtil.isBlank(this.comment) || labelBlank && this.bookmarkCheckBox.isSelected()));
    }

    private void closeDialog() {
        this.dispose();
    }

    public boolean isOK() {
        return this.ok;
    }

    public void setAddressLabel(AddressLabel a) {
        this.removeDocumentListeners();
        this.bank = a.getBank();
        this.address = a.getAddress();
        this.label = a.getLabel();
        this.comment = a.getComment();
        if (this.bank >= 0 && this.bank <= 255) {
            this.bankTextField.setText(String.format("$%02X", this.bank));
        } else {
            this.bankTextField.setText("");
            this.bank = -1;
        }
        if (this.address >= 0 && this.address <= 65535) {
            this.addressTextField.setText(String.format("$%04X", this.address));
        } else {
            this.addressTextField.setText("");
            this.address = -1;
        }
        if (!StringUtil.isBlank(this.label)) {
            this.label = this.label.trim();
            this.labelTextField.setText(this.label);
        } else {
            this.label = null;
            this.labelTextField.setText("");
        }
        if (!StringUtil.isBlank(this.comment)) {
            this.comment = this.comment.trim();
            this.commentTextArea.setText(this.comment);
        } else {
            this.comment = null;
            this.commentTextArea.setText("");
        }
        this.codeCheckBox.setSelected(a.isCode());
        this.bookmarkCheckBox.setSelected(a.isBookmark());
        this.updateOkButton();
        this.addDocumentListeners();
    }

    public AddressLabel getAddressLabel() {
        return this.result;
    }

    private void initComponents() {
        this.addressLabel = new JLabel();
        this.addressTextField = new JTextField();
        this.labelLabel = new JLabel();
        this.labelTextField = new JTextField();
        this.commentLabel = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.codeCheckBox = new JCheckBox();
        this.scrollPane = new JScrollPane();
        this.commentTextArea = new JTextArea();
        this.bankLabel = new JLabel();
        this.bankTextField = new JTextField();
        this.bookmarkCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Address Label");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateAddressLabelDialog.this.formWindowClosing(evt);
            }
        });
        this.addressLabel.setText("Address:");
        this.addressLabel.setMaximumSize(null);
        this.addressLabel.setMinimumSize(null);
        this.addressLabel.setPreferredSize(null);
        this.addressTextField.setColumns(6);
        this.addressTextField.setText("$0000");
        this.addressTextField.setMaximumSize(null);
        this.addressTextField.setMinimumSize(null);
        this.addressTextField.setPreferredSize(null);
        this.labelLabel.setText("Label:");
        this.labelLabel.setMaximumSize(null);
        this.labelLabel.setMinimumSize(null);
        this.labelLabel.setPreferredSize(null);
        this.labelTextField.setColumns(15);
        this.labelTextField.setMaximumSize(null);
        this.labelTextField.setMinimumSize(null);
        this.commentLabel.setText("Comment:");
        this.commentLabel.setMaximumSize(null);
        this.commentLabel.setMinimumSize(null);
        this.commentLabel.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("  Cancel  ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAddressLabelDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAddressLabelDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.codeCheckBox.setSelected(true);
        this.codeCheckBox.setText("Code");
        this.codeCheckBox.setMaximumSize(null);
        this.codeCheckBox.setMinimumSize(null);
        this.codeCheckBox.setPreferredSize(null);
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setMinimumSize(null);
        this.commentTextArea.setColumns(15);
        this.commentTextArea.setRows(5);
        this.commentTextArea.setMaximumSize(null);
        this.commentTextArea.setMinimumSize(null);
        this.scrollPane.setViewportView(this.commentTextArea);
        this.bankLabel.setText("Bank:");
        this.bankLabel.setMaximumSize(null);
        this.bankLabel.setMinimumSize(null);
        this.bankLabel.setPreferredSize(null);
        this.bankTextField.setColumns(4);
        this.bankTextField.setMaximumSize(null);
        this.bankTextField.setMinimumSize(null);
        this.bankTextField.setPreferredSize(null);
        this.bookmarkCheckBox.setSelected(true);
        this.bookmarkCheckBox.setText("Bookmark");
        this.bookmarkCheckBox.setMaximumSize(null);
        this.bookmarkCheckBox.setMinimumSize(null);
        this.bookmarkCheckBox.setPreferredSize(null);
        this.bookmarkCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAddressLabelDialog.this.bookmarkCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bankLabel, -2, -1, -2).addComponent(this.labelLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelTextField, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bankTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.addressLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.codeCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bookmarkCheckBox, -2, -1, -2).addGap(0, 129, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.commentLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel, -2, -1, -2).addComponent(this.addressTextField, -2, -1, -2).addComponent(this.bankLabel, -2, -1, -2).addComponent(this.bankTextField, -2, -1, -2).addComponent(this.codeCheckBox, -2, -1, -2).addComponent(this.bookmarkCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelLabel, -2, -1, -2).addComponent(this.labelTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commentLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.result = new AddressLabel(this.bank, this.address, this.label, this.comment, this.codeCheckBox.isSelected(), this.bookmarkCheckBox.isSelected());
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void bookmarkCheckBoxActionPerformed(ActionEvent evt) {
        this.updateOkButton();
    }
}

