/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.fds;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.files.ArchiveEntry;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.archive.ArchiveFileChooser;
import nintaco.gui.fds.DiskActivityIndicator;
import nintaco.gui.fds.FamicomDiskSystemPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class FamicomDiskSystemOptionsDialog
extends JDialog {
    private boolean loadingsBIOS;
    private FilePath biosFilePath;
    private DiskActivityIndicator diskActivityIndicator;
    private JPanel biosFilePanel;
    private JButton browseButton;
    private ButtonGroup buttonGroup;
    private JButton cancelButton;
    private JRadioButton capsLockRadioButton;
    private JPanel driveActivityIndicatorPanel;
    private JCheckBox fastForwardCheckBox;
    private JTextField fileTextField;
    private JRadioButton kanaLockRadioButton;
    private JRadioButton noneRadioButton;
    private JRadioButton numLockRadioButton;
    private JButton okButton;
    private JRadioButton scrollLockRadioButton;

    public FamicomDiskSystemOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initTextField();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initTextField() {
        this.biosFilePanel.setPreferredSize(null);
        this.driveActivityIndicatorPanel.setPreferredSize(null);
        this.fileTextField.setColumns(60);
        GuiUtil.addTextFieldEditListener(this.fileTextField, this::fileTextFieldEdited);
        GuiUtil.addLoseFocusListener((Window)this, this.fileTextField);
    }

    private void closeDialog() {
        if (!this.loadingsBIOS) {
            this.dispose();
        }
    }

    private void loadFields() {
        FamicomDiskSystemPrefs prefs = AppPrefs.getInstance().getFamicomDiskSystemPrefs();
        FilePath biosFile = prefs.getBiosFile();
        if (biosFile != null) {
            this.fileTextField.setText(biosFile.toLongString());
        }
        switch (prefs.getDiskActivityIndicator()) {
            case NONE: {
                this.noneRadioButton.setSelected(true);
                break;
            }
            case NUM_LOCK: {
                this.numLockRadioButton.setSelected(true);
                break;
            }
            case CAPS_LOCK: {
                this.capsLockRadioButton.setSelected(true);
                break;
            }
            case SCROLL_LOCK: {
                this.scrollLockRadioButton.setSelected(true);
                break;
            }
            case KANA_LOCK: {
                this.kanaLockRadioButton.setSelected(true);
            }
        }
        this.fastForwardCheckBox.setSelected(prefs.isFastForwardDuringDiskAccess());
    }

    private void saveFields() {
        FamicomDiskSystemPrefs prefs = AppPrefs.getInstance().getFamicomDiskSystemPrefs();
        prefs.setBiosFile(this.biosFilePath);
        prefs.setDiskActivityIndicator(this.diskActivityIndicator);
        prefs.setFastForwardDuringDiskAccess(this.fastForwardCheckBox.isSelected());
        AppPrefs.save();
    }

    private void fileTextFieldEdited() {
        this.okButton.setEnabled(!StringUtil.isBlank(this.fileTextField.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBIOS(FilePath filePath, PleaseWaitDialog pleaseWaitDialog) {
        try {
            FileUtil.getInputStream(filePath, (in, length) -> {
                if (length != 8192L) {
                    this.displayLoadBiosError(pleaseWaitDialog, "<p><b>Invalid BIOS file.</b></p><p>The size of the provided file is not 8192 bytes.</p>");
                    return;
                }
                try {
                    App.loadFdsBIOS(in, length);
                }
                catch (Throwable t) {
                    this.displayLoadBiosError(pleaseWaitDialog);
                    return;
                }
                pleaseWaitDialog.dispose();
                EventQueue.invokeLater(this::biosLoadCompleted);
            });
        }
        catch (FileNotFoundException f) {
            this.displayLoadBiosError(pleaseWaitDialog, "BIOS file not found.");
        }
        catch (Throwable t) {
            this.displayLoadBiosError(pleaseWaitDialog);
        }
        finally {
            pleaseWaitDialog.dispose();
            EventQueue.invokeLater(() -> {
                this.loadingsBIOS = false;
            });
        }
    }

    private void biosLoadCompleted() {
        this.loadingsBIOS = false;
        this.saveFields();
        App.fireDiskActivityIndicatorChanged();
        this.dispose();
    }

    private void displayLoadBiosError(PleaseWaitDialog pleaseWaitDialog) {
        this.displayLoadBiosError(pleaseWaitDialog, "Failed to load BIOS file.");
    }

    private void displayLoadBiosError(PleaseWaitDialog pleaseWaitDialog, String errorMessage) {
        pleaseWaitDialog.dispose();
        GuiUtil.displayError(this, errorMessage);
    }

    private void openArchiveFile(String archiveFileName, PleaseWaitDialog pleaseWaitDialog) {
        List<String> entries = null;
        try {
            entries = ArchiveEntry.toNames(FileUtil.getArchiveEntries(archiveFileName, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List<String> files = entries;
        pleaseWaitDialog.dispose();
        if (files == null) {
            GuiUtil.displayError(this, "Failed to open archive file.");
        } else {
            switch (files.size()) {
                case 0: {
                    GuiUtil.displayError(this, "The archive does not contain any files.");
                    break;
                }
                case 1: {
                    EventQueue.invokeLater(() -> this.fileTextField.setText(new FilePath((String)files.get(0), archiveFileName).toLongString()));
                    break;
                }
                default: {
                    EventQueue.invokeLater(() -> this.showArchiveFileChooser(archiveFileName, files));
                }
            }
        }
    }

    private void showArchiveFileChooser(String archiveFileName, List<String> files) {
        ArchiveFileChooser archiveChooser = new ArchiveFileChooser((Window)this, files, -1);
        archiveChooser.setVisible(true);
        String entryFileName = archiveChooser.getSelectedFile();
        if (entryFileName != null) {
            this.fileTextField.setText(new FilePath(entryFileName, archiveFileName).toLongString());
        }
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.biosFilePanel = new JPanel();
        this.fileTextField = new JTextField();
        this.browseButton = new JButton();
        this.driveActivityIndicatorPanel = new JPanel();
        this.noneRadioButton = new JRadioButton();
        this.numLockRadioButton = new JRadioButton();
        this.capsLockRadioButton = new JRadioButton();
        this.scrollLockRadioButton = new JRadioButton();
        this.kanaLockRadioButton = new JRadioButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.fastForwardCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Famicom Disk System Options");
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FamicomDiskSystemOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.biosFilePanel.setBorder(BorderFactory.createTitledBorder("BIOS File"));
        this.biosFilePanel.setMaximumSize(null);
        this.fileTextField.setColumns(60);
        this.fileTextField.setMaximumSize(null);
        this.fileTextField.setMinimumSize(null);
        this.fileTextField.setPreferredSize(null);
        this.browseButton.setText("Browse...");
        this.browseButton.setMaximumSize(null);
        this.browseButton.setMinimumSize(null);
        this.browseButton.setPreferredSize(null);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamicomDiskSystemOptionsDialog.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout biosFilePanelLayout = new GroupLayout(this.biosFilePanel);
        this.biosFilePanel.setLayout(biosFilePanelLayout);
        biosFilePanelLayout.setHorizontalGroup(biosFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(biosFilePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, -1, -2).addContainerGap()));
        biosFilePanelLayout.setVerticalGroup(biosFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(biosFilePanelLayout.createSequentialGroup().addContainerGap().addGroup(biosFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton, -2, -1, -2).addComponent(this.fileTextField, -2, -1, -2)).addContainerGap()));
        biosFilePanelLayout.linkSize(1, this.browseButton, this.fileTextField);
        this.driveActivityIndicatorPanel.setBorder(BorderFactory.createTitledBorder("Drive Activity Indicator"));
        this.driveActivityIndicatorPanel.setMaximumSize(null);
        this.buttonGroup.add(this.noneRadioButton);
        this.noneRadioButton.setText("None");
        this.noneRadioButton.setPreferredSize(null);
        this.buttonGroup.add(this.numLockRadioButton);
        this.numLockRadioButton.setText("Num Lock");
        this.numLockRadioButton.setPreferredSize(null);
        this.buttonGroup.add(this.capsLockRadioButton);
        this.capsLockRadioButton.setText("Caps Lock");
        this.capsLockRadioButton.setPreferredSize(null);
        this.buttonGroup.add(this.scrollLockRadioButton);
        this.scrollLockRadioButton.setText("Scroll Lock");
        this.scrollLockRadioButton.setPreferredSize(null);
        this.buttonGroup.add(this.kanaLockRadioButton);
        this.kanaLockRadioButton.setText("Kana Lock");
        this.kanaLockRadioButton.setPreferredSize(null);
        GroupLayout driveActivityIndicatorPanelLayout = new GroupLayout(this.driveActivityIndicatorPanel);
        this.driveActivityIndicatorPanel.setLayout(driveActivityIndicatorPanelLayout);
        driveActivityIndicatorPanelLayout.setHorizontalGroup(driveActivityIndicatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(driveActivityIndicatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.noneRadioButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.numLockRadioButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.capsLockRadioButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scrollLockRadioButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.kanaLockRadioButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        driveActivityIndicatorPanelLayout.setVerticalGroup(driveActivityIndicatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(driveActivityIndicatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(driveActivityIndicatorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noneRadioButton, -2, -1, -2).addComponent(this.numLockRadioButton, -2, -1, -2).addComponent(this.capsLockRadioButton, -2, -1, -2).addComponent(this.scrollLockRadioButton, -2, -1, -2).addComponent(this.kanaLockRadioButton, -2, -1, -2)).addContainerGap()));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("  Cancel  ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamicomDiskSystemOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamicomDiskSystemOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.fastForwardCheckBox.setSelected(true);
        this.fastForwardCheckBox.setText("Fast forward during disk access");
        this.fastForwardCheckBox.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fastForwardCheckBox, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.driveActivityIndicatorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.biosFilePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.biosFilePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.driveActivityIndicatorPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fastForwardCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String enteredDir;
        String enteredFilePath = this.fileTextField.getText().trim();
        if (!enteredFilePath.isEmpty()) {
            int lt = enteredFilePath.indexOf(60);
            if (lt >= 0) {
                enteredFilePath = enteredFilePath.substring(0, lt);
            }
            enteredDir = FileUtil.getDirectoryPath(enteredFilePath);
        } else {
            enteredDir = null;
        }
        JFileChooser chooser = GuiUtil.createFileChooser("Open BIOS File", enteredDir != null ? enteredDir : AppPrefs.getInstance().getPaths().getFdsBiosDir(), new FileExtensionFilter(0, "All files (*.*)"));
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setFdsBiosDir((String)d)) == 0) {
            String fileName = chooser.getSelectedFile().toString();
            if (FileUtil.isArchiveFile(fileName)) {
                PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
                pleaseWaitDialog.setMessage("Opening archive file...");
                new Thread(() -> this.openArchiveFile(fileName, pleaseWaitDialog)).start();
                pleaseWaitDialog.showAfterDelay();
            } else {
                this.fileTextField.setText(fileName);
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.loadingsBIOS) {
            return;
        }
        String file = this.fileTextField.getText().trim();
        if (file.isEmpty()) {
            GuiUtil.displayError(this, "Missing BIOS file path.");
            return;
        }
        this.biosFilePath = FilePath.fromLongString(file);
        if (this.biosFilePath == null) {
            GuiUtil.displayError(this, "Invalid BIOS file path.");
            return;
        }
        this.diskActivityIndicator = this.numLockRadioButton.isSelected() ? DiskActivityIndicator.NUM_LOCK : (this.capsLockRadioButton.isSelected() ? DiskActivityIndicator.CAPS_LOCK : (this.scrollLockRadioButton.isSelected() ? DiskActivityIndicator.SCROLL_LOCK : (this.kanaLockRadioButton.isSelected() ? DiskActivityIndicator.KANA_LOCK : DiskActivityIndicator.NONE)));
        this.loadingsBIOS = true;
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        pleaseWaitDialog.setMessage("Loading BIOS file...");
        new Thread(() -> this.loadBIOS(this.biosFilePath, pleaseWaitDialog)).start();
        pleaseWaitDialog.showAfterDelay();
    }
}

