/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nintaco.gui.hexeditor.CharTable;
import nintaco.gui.hexeditor.DataSource;
import nintaco.gui.hexeditor.DataSourceCharSequence;
import nintaco.gui.hexeditor.SearchQuery;

public final class Searcher {
    public static final Result NOT_FOUND = new Result();

    public static Result findNext(DataSource[] sources, DataSource source, SearchQuery query, CharTable charTable) {
        int maxAddress;
        int minAddress;
        int end;
        if (source.getIndex() < 0 || query.getFindWhat() == null) {
            return NOT_FOUND;
        }
        int start = source.getStartSelectedAddress();
        if (start > (end = source.getEndSelectedAddress())) {
            int temp = start;
            start = end;
            end = temp;
        }
        if (start >= source.getSize()) {
            start = source.getSize() - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end >= source.getSize()) {
            end = source.getSize() - 1;
        }
        if (end < 0) {
            end = 0;
        }
        source.setStartSelectedAddress(start);
        source.setEndSelectedAddress(end);
        Pattern pattern = null;
        int[] lower = null;
        int[] upper = null;
        if (query.getData() == SearchQuery.Data.Text && query.isRegularExpression()) {
            pattern = Pattern.compile(query.getFindWhat().getValue(), query.isMatchCase() ? 0 : 2);
        } else if (query.getData() == SearchQuery.Data.Text && !query.isMatchCase()) {
            lower = query.getFindWhat().parseLower(charTable);
            upper = query.getFindWhat().parseUpper(charTable);
        } else {
            lower = query.getFindWhat().parse(charTable);
            upper = null;
        }
        if (query.getScope() == SearchQuery.Scope.Selection) {
            minAddress = start;
            maxAddress = end;
        } else if (query.getDirection() == SearchQuery.Direction.Down) {
            minAddress = start;
            maxAddress = source.getSize() - 1;
        } else {
            minAddress = 0;
            maxAddress = end;
        }
        Result result = Searcher.find(query, source, charTable, pattern, lower, upper, minAddress, maxAddress);
        if (result != NOT_FOUND) {
            boolean atCurrent;
            boolean bl = atCurrent = result.getStart() == start && result.getEnd() == end;
            if (!atCurrent || atCurrent && query.getScope() == SearchQuery.Scope.Selection) {
                return result;
            }
        }
        if ((result = query.getDirection() == SearchQuery.Direction.Down ? Searcher.find(query, source, charTable, pattern, lower, upper, minAddress + 1, maxAddress) : Searcher.find(query, source, charTable, pattern, lower, upper, minAddress, maxAddress - 1)) != NOT_FOUND) {
            return result;
        }
        if (query.getScope() == SearchQuery.Scope.Selection || !query.isWrapSearches()) {
            return NOT_FOUND;
        }
        if (query.getScope() == SearchQuery.Scope.AllViews) {
            for (int i = 0; i < sources.length - 1; ++i) {
                int j = source.getIndex();
                if (query.getDirection() == SearchQuery.Direction.Down) {
                    if ((j += i + 1) >= sources.length) {
                        j -= sources.length;
                    }
                } else if ((j -= i + 1) < 0) {
                    j += sources.length;
                }
                if ((result = Searcher.find(query, sources[j], charTable, pattern, lower, upper, 0, sources[j].getSize() - 1)) == NOT_FOUND) continue;
                return result;
            }
        }
        if (query.getDirection() == SearchQuery.Direction.Down) {
            return Searcher.find(query, source, charTable, pattern, lower, upper, 0, maxAddress);
        }
        return Searcher.find(query, source, charTable, pattern, lower, upper, minAddress, source.getSize() - 1);
    }

    private static Result find(SearchQuery query, DataSource source, CharTable charTable, Pattern pattern, int[] lower, int[] upper, int minAddress, int maxAddress) {
        if (minAddress >= source.getSize()) {
            minAddress = source.getSize() - 1;
        }
        if (minAddress < 0) {
            minAddress = 0;
        }
        if (maxAddress >= source.getSize()) {
            maxAddress = source.getSize() - 1;
        }
        if (maxAddress < 0) {
            maxAddress = 0;
        }
        Result result = query.getDirection() == SearchQuery.Direction.Down ? (pattern == null ? Searcher.findHexDown(source, lower, upper, minAddress, maxAddress) : Searcher.findRegExDown(source, charTable, pattern, minAddress, maxAddress)) : (pattern == null ? Searcher.findHexUp(source, lower, upper, minAddress, maxAddress) : Searcher.findRegExUp(source, charTable, pattern, minAddress, maxAddress));
        return result;
    }

    private static Result findRegExUp(DataSource source, CharTable charTable, Pattern pattern, int minAddress, int maxAddress) {
        DataSourceCharSequence sequence = new DataSourceCharSequence(source, charTable);
        Matcher matcher = pattern.matcher(sequence);
        int lastStart = -1;
        int lastEnd = -1;
        if (matcher.find(minAddress)) {
            do {
                int start = matcher.start();
                int end = matcher.end() - 1;
                if (end > maxAddress) break;
                lastStart = start;
                lastEnd = end;
            } while (matcher.find(lastStart + 1));
        }
        if (lastStart >= 0) {
            return new Result(source, lastStart, lastEnd);
        }
        return NOT_FOUND;
    }

    private static Result findRegExDown(DataSource source, CharTable charTable, Pattern pattern, int minAddress, int maxAddress) {
        DataSourceCharSequence sequence = new DataSourceCharSequence(source, charTable);
        Matcher matcher = pattern.matcher(sequence);
        if (matcher.find(minAddress)) {
            int start = matcher.start();
            int end = matcher.end() - 1;
            if (end <= maxAddress) {
                return new Result(sequence.getSource(), start, end);
            }
        }
        return NOT_FOUND;
    }

    private static Result findHexUp(DataSource source, int[] lower, int[] upper, int minAddress, int maxAddress) {
        for (int address = maxAddress -= lower.length - 1; address >= minAddress; --address) {
            if (!Searcher.matchesHex(source, address, lower, upper)) continue;
            return new Result(source, address, address + lower.length - 1);
        }
        return NOT_FOUND;
    }

    private static Result findHexDown(DataSource source, int[] lower, int[] upper, int minAddress, int maxAddress) {
        maxAddress -= lower.length - 1;
        for (int address = minAddress; address <= maxAddress; ++address) {
            if (!Searcher.matchesHex(source, address, lower, upper)) continue;
            return new Result(source, address, address + lower.length - 1);
        }
        return NOT_FOUND;
    }

    private static boolean matchesHex(DataSource source, int address, int[] lower, int[] upper) {
        for (int offset = lower.length - 1; offset >= 0; --offset) {
            int value = source.peek(address + offset) & 0xFF;
            if (value == lower[offset] || upper != null && value == upper[offset]) continue;
            return false;
        }
        return true;
    }

    private Searcher() {
    }

    public static class Result {
        private final DataSource source;
        private final int start;
        private final int end;
        private final boolean found;

        public Result() {
            this.found = false;
            this.start = -1;
            this.end = -1;
            this.source = null;
        }

        public Result(DataSource source, int start, int end) {
            this.source = source;
            this.found = true;
            this.start = start;
            this.end = end;
        }

        public DataSource getSource() {
            return this.source;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isFound() {
            return this.found;
        }

        public boolean equals(Object obj) {
            Result r = (Result)obj;
            return r.getSource() == this.source && r.getStart() == this.start && r.getEnd() == this.end && r.isFound() == this.found;
        }
    }
}

