/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import nintaco.gui.Int;
import nintaco.gui.historyeditor.HistoryBookmark;

public class BookmarksModel
extends AbstractListModel<HistoryBookmark> {
    private final List<HistoryBookmark> bookmarks = new ArrayList<HistoryBookmark>();

    public List<HistoryBookmark> getBookmarks() {
        return new ArrayList<HistoryBookmark>(this.bookmarks);
    }

    public void clear() {
        int priorLastIndex = this.bookmarks.size() - 1;
        this.bookmarks.clear();
        if (priorLastIndex >= 0) {
            this.fireIntervalRemoved(this, 0, priorLastIndex);
        }
    }

    public void setBookmarks(List<HistoryBookmark> bookmarks) {
        this.clear();
        this.bookmarks.addAll(bookmarks);
        if (!this.bookmarks.isEmpty()) {
            this.fireIntervalAdded(this, 0, this.bookmarks.size() - 1);
        }
    }

    public void add(HistoryBookmark bookmark) {
        int index = this.bookmarks.indexOf(bookmark);
        if (index >= 0) {
            this.bookmarks.set(index, bookmark);
            this.fireContentsChanged(this, index, index);
        } else {
            this.bookmarks.add(bookmark);
            Collections.sort(this.bookmarks);
            this.fireContentsChanged(this, 0, this.bookmarks.size() - 1);
        }
    }

    public HistoryBookmark delete(int index) {
        HistoryBookmark bookmark = null;
        if (index >= 0 && index < this.bookmarks.size()) {
            bookmark = this.bookmarks.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
        return bookmark;
    }

    public void handleFramesInserted(int startIndex, int endIndex) {
        int insertedFrames = endIndex - startIndex + 1;
        for (int i = this.bookmarks.size() - 1; i >= 0; --i) {
            HistoryBookmark bookmark = this.bookmarks.get(i);
            int frame = bookmark.getFrame();
            if (frame < startIndex) continue;
            this.bookmarks.set(i, new HistoryBookmark(bookmark.getName(), frame + insertedFrames));
        }
    }

    public HistoryBookmark[] handleFramesDeleted(int startIndex, int endIndex) {
        ArrayList<HistoryBookmark> deletedBookmarks = new ArrayList<HistoryBookmark>();
        int deletedFrames = endIndex - startIndex + 1;
        for (int i = this.bookmarks.size() - 1; i >= 0; --i) {
            HistoryBookmark bookmark = this.bookmarks.get(i);
            int frame = bookmark.getFrame();
            if (frame >= startIndex && frame <= endIndex) {
                deletedBookmarks.add(this.bookmarks.remove(i));
                this.fireIntervalRemoved(this, i, i);
                continue;
            }
            if (frame <= endIndex) continue;
            this.bookmarks.set(i, new HistoryBookmark(bookmark.getName(), frame - deletedFrames));
        }
        return deletedBookmarks.toArray(new HistoryBookmark[deletedBookmarks.size()]);
    }

    public HistoryBookmark findBookmark(int frame) {
        for (int i = this.bookmarks.size() - 1; i >= 0; --i) {
            HistoryBookmark bookmark = this.bookmarks.get(i);
            if (bookmark.getFrame() != frame) continue;
            return bookmark;
        }
        return null;
    }

    public int indexOf(HistoryBookmark bookmark) {
        return this.bookmarks.indexOf(bookmark);
    }

    public Set<Int> getBookmarkedRows() {
        HashSet<Int> set = new HashSet<Int>();
        for (int i = this.bookmarks.size() - 1; i >= 0; --i) {
            set.add(new Int(this.bookmarks.get(i).getFrame()));
        }
        return set;
    }

    public boolean isEmpty() {
        return this.bookmarks.isEmpty();
    }

    @Override
    public int getSize() {
        return this.bookmarks.size();
    }

    @Override
    public HistoryBookmark getElementAt(int index) {
        return this.bookmarks.get(index);
    }
}

