/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class HistoryBookmarkEditor
extends JDialog {
    private final int maxFrameValue;
    private boolean ok;
    private String bookmarkName;
    private int bookmarkFrame;
    private JButton cancelButton;
    private JLabel frameLabel;
    private JTextField frameTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton okButton;

    public HistoryBookmarkEditor(Window parent, HistoryTableModel historyTableModel) {
        super(parent);
        this.setModal(true);
        this.maxFrameValue = historyTableModel.getRowCount() - 1;
        this.initComponents();
        this.initTextFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.nameTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.frameTextField);
        GuiUtil.addTextFieldEditListener(this.nameTextField, this::textFieldsEdited);
        GuiUtil.addTextFieldEditListener(this.frameTextField, this::textFieldsEdited);
    }

    public void setHistoryBookmark(HistoryBookmark bookmark) {
        this.setHistoryBookmark(bookmark.getName(), bookmark.getFrame());
    }

    public void setHistoryBookmark(String name, int frame) {
        this.nameTextField.setText(name);
        this.frameTextField.setText(Integer.toString(frame));
        this.textFieldsEdited();
    }

    public void setMode(boolean editing) {
        this.setTitle(editing ? "Edit Bookmark" : "Add Bookmark");
    }

    private void closeDialog() {
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public HistoryBookmark getBookmark() {
        return new HistoryBookmark(this.bookmarkName, this.bookmarkFrame);
    }

    private boolean textFieldsEdited() {
        this.bookmarkName = this.nameTextField.getText().trim();
        this.bookmarkFrame = StringUtil.parseInt(this.frameTextField.getText(), false, this.maxFrameValue);
        boolean enabled = !this.bookmarkName.isEmpty() && this.bookmarkFrame >= 0;
        this.okButton.setEnabled(enabled);
        return enabled;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.frameLabel = new JLabel();
        this.frameTextField = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(null);
        this.nameLabel.setText("Name:");
        this.nameLabel.setMaximumSize(null);
        this.nameLabel.setMinimumSize(null);
        this.nameLabel.setPreferredSize(null);
        this.nameTextField.setColumns(32);
        this.nameTextField.setMaximumSize(null);
        this.nameTextField.setMinimumSize(null);
        this.nameTextField.setPreferredSize(null);
        this.frameLabel.setText("Frame:");
        this.frameLabel.setMaximumSize(null);
        this.frameLabel.setMinimumSize(null);
        this.frameLabel.setPreferredSize(null);
        this.frameTextField.setColumns(8);
        this.frameTextField.setMaximumSize(null);
        this.frameTextField.setMinimumSize(null);
        this.frameTextField.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryBookmarkEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryBookmarkEditor.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.frameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frameTextField, -2, -1, -2))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel, -2, -1, -2).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.frameLabel, -2, -1, -2).addComponent(this.frameTextField, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addGap(15, 15, 15)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = this.textFieldsEdited();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

