/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.tasks;

import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.ScreenRenderer;
import nintaco.apu.AudioProcessor;
import nintaco.apu.SystemAudioProcessor;
import nintaco.gui.historyeditor.tasks.FramePlayedListener;
import nintaco.gui.historyeditor.tasks.FrameRenderer;
import nintaco.gui.historyeditor.tasks.TaskTerminatedListener;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.task.Task;
import nintaco.util.GuiUtil;
import nintaco.util.StreamUtil;
import nintaco.util.TimeUtil;

public class PlayMovieTask
extends Task {
    private final Movie movie;
    private final int startFrameIndex;
    private final int endFrameIndex;
    private final FramePlayedListener listener;
    private final AudioProcessor audioProcessor;
    private final ScreenRenderer screenRenderer;
    private final ScreenRenderer screenRenderer2;
    private final TaskTerminatedListener taskTerminatedListener;
    private volatile boolean renderingEnabled;
    private volatile boolean audioEnabled;
    private volatile boolean delayEnabled;
    private volatile boolean disposeEnabled = true;
    private FrameRenderer frameRenderer;
    private FrameRenderer frameRenderer2;
    private int frameIndex;
    private int renderIndex;

    public PlayMovieTask(Movie movie, int startFrameIndex, int endFrameIndex, boolean realtime, FramePlayedListener listener) {
        this(movie, startFrameIndex, endFrameIndex, realtime, listener, null, null, null, null);
    }

    public PlayMovieTask(Movie movie, int startFrameIndex, int endFrameIndex, boolean realtime, FramePlayedListener listener, ScreenRenderer screenRenderer, ScreenRenderer screenRenderer2, AudioProcessor audioProcessor, TaskTerminatedListener taskTerminatedListener) {
        this.movie = movie;
        this.startFrameIndex = Math.max(0, startFrameIndex);
        this.endFrameIndex = Math.max(0, endFrameIndex);
        this.listener = listener;
        this.setRealtime(realtime);
        this.screenRenderer = screenRenderer == null ? this::render : screenRenderer;
        this.screenRenderer2 = screenRenderer2 == null ? this::render2 : screenRenderer2;
        this.audioProcessor = audioProcessor == null ? this::processOutputSample : audioProcessor;
        this.taskTerminatedListener = taskTerminatedListener;
    }

    public void setRealtime(boolean realtime) {
        this.setRenderingEnabled(realtime);
        this.setAudioEnabled(realtime);
        this.setDelayEnabled(realtime);
    }

    public void setRenderingEnabled(boolean renderingEnabled) {
        this.renderingEnabled = renderingEnabled;
    }

    public void setAudioEnabled(boolean audioEnabled) {
        this.audioEnabled = audioEnabled;
    }

    public void setDelayEnabled(boolean delayEnabled) {
        this.delayEnabled = delayEnabled;
    }

    public void setFrameRenderer(FrameRenderer frameRenderer) {
        this.frameRenderer = frameRenderer;
    }

    public void setFrameRenderer2(FrameRenderer frameRenderer2) {
        this.frameRenderer2 = frameRenderer2;
    }

    public void setDisposeEnabled(boolean disposeEnabled) {
        this.disposeEnabled = disposeEnabled;
    }

    @Override
    public void loop() {
        Machine machine;
        if (!this.running || this.movie == null || this.startFrameIndex < 0 || this.endFrameIndex < this.startFrameIndex) {
            return;
        }
        boolean vsDualSystem = this.movie.isVsDualSystem();
        this.renderIndex = this.frameIndex = this.startFrameIndex & 0xFFFFFFC0;
        int blockIndex = this.frameIndex >> Movie.BLOCK_SHIFT;
        MovieBlock movieBlock = this.movie.movieBlocks.get(blockIndex);
        if (movieBlock.saveState == null) {
            return;
        }
        try {
            machine = (Machine)StreamUtil.readObject(movieBlock.saveState);
        }
        catch (Throwable t) {
            return;
        }
        MachineRunner machineRunner = new MachineRunner(machine);
        Mapper mapper = machine.getMapper();
        mapper.restore(App.getCartFile());
        mapper.restore(App.getFdsFile());
        mapper.restore(App.getNsfFile());
        machine.getPPU().setScreenRenderer(this.screenRenderer);
        if (vsDualSystem) {
            ((MainCPU)machine.getCPU()).getSubPPU().setScreenRenderer(this.screenRenderer2);
        }
        machine.getAPU().setAudioProcessor(this.audioProcessor);
        ImagePane imagePane = App.getImageFrame().getImagePane();
        SystemAudioProcessor systemAudioProcessor = App.getSystemAudioProcessor();
        long next = System.nanoTime();
        while (this.running && this.frameIndex <= this.endFrameIndex) {
            GuiUtil.suppressScreensaver();
            int buttonIndex = this.frameIndex & 0x3F;
            if (buttonIndex == 0) {
                blockIndex = this.frameIndex >> Movie.BLOCK_SHIFT;
                movieBlock = this.movie.movieBlocks.get(blockIndex);
                try {
                    movieBlock.saveState = StreamUtil.toByteArrayOutputStream(machine).toByteArray();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            MovieFrame movieFrame = this.movie.movieFrames[0x7F & this.frameIndex];
            movieFrame.frameIndex = this.frameIndex;
            movieFrame.audioLength = 0;
            next = machineRunner.runFrame(movieBlock, buttonIndex, next);
            if (this.frameIndex >= this.startFrameIndex) {
                if (this.renderingEnabled) {
                    if (this.frameRenderer == null) {
                        imagePane.render(movieFrame.screen);
                        if (vsDualSystem) {
                            if (this.frameRenderer2 == null) {
                                SubMonitorFrame subMonitorFrame = App.getSubMonitorFrame();
                                if (subMonitorFrame != null) {
                                    subMonitorFrame.getImagePane().render(movieFrame.screen2);
                                }
                            } else {
                                this.frameRenderer2.render(movieFrame.screen2);
                            }
                        }
                    } else {
                        this.frameRenderer.render(movieFrame.screen);
                    }
                }
                if (this.audioEnabled) {
                    systemAudioProcessor.processOutputSamples(movieFrame.audioSamples, movieFrame.audioLength);
                }
                if (this.listener != null) {
                    this.listener.framePlayed(this, this.frameIndex, machineRunner);
                }
                if (this.delayEnabled) {
                    next = TimeUtil.sleep(next, mapper);
                }
            }
            ++this.frameIndex;
        }
        if (this.disposeEnabled) {
            machineRunner.dispose();
        }
        if (this.taskTerminatedListener != null) {
            this.taskTerminatedListener.taskTerminated(this);
        }
    }

    private void processOutputSample(int value) {
        this.movie.movieFrames[0x7F & this.frameIndex].processOutputSample(value);
    }

    private int[] render() {
        return this.movie.movieFrames[0x7F & this.renderIndex++].screen;
    }

    private int[] render2() {
        return this.movie.movieFrames[0x7F & this.renderIndex - 1].screen2;
    }
}

