/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image;

import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import nintaco.App;
import nintaco.Machine;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.ImagePane;
import nintaco.mappers.nintendo.vs.DualAPU;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.util.GuiUtil;

public class SubMonitorFrame
extends JFrame {
    private final ImagePane imagePane = new ImagePane();
    private boolean wasMaximized;

    public SubMonitorFrame() {
        this.initComponents();
        this.setContentPane(this.imagePane);
        GuiUtil.scaleFonts(this);
        this.copyOtherImagePaneFields();
        this.pack();
        ImageFrame imageFrame = App.getImageFrame();
        if (GuiUtil.isMaximized(imageFrame)) {
            Rectangle bounds = GuiUtil.getNextGraphicsDevice(imageFrame).getDefaultConfiguration().getBounds();
            this.setLocation(bounds.x, bounds.y);
            GuiUtil.maximize(this);
        } else {
            GuiUtil.moveToImageFrameMonitor(this);
        }
    }

    public void init() {
        Machine machine = App.getMachine();
        if (machine != null) {
            ((MainCPU)machine.getCPU()).setScreenRenderer(this.imagePane);
        }
    }

    private void copyOtherImagePaneFields() {
        ImagePane other = App.getImageFrame().getImagePane();
        this.imagePane.setCursorType(other.getCursorType());
        this.imagePane.setCursorVisible(other.isCursorVisible());
        this.imagePane.setFrameColor(other.getFrameColor());
        this.imagePane.setHideFullscreenMouseCursor(other.isHideFullscreenMouseCursor());
        this.imagePane.setHideInactiveMouseCursor(other.isHideInactiveMouseCursor());
        this.imagePane.setPaused(other.isPaused());
        this.imagePane.setRewinding(other.isRewinding());
        this.imagePane.setShowFPS(other.isShowFPS());
        this.imagePane.setShowStatusMessages(other.isShowStatusMessages());
        this.imagePane.setSmoothScaling(other.isSmoothScaling());
        this.imagePane.setUseTvAspectRatio(other.isUseTvAspectRatio());
        this.imagePane.setTVSystem(other.getTVSystem());
        this.imagePane.setScreenScale(other.getScreenScale());
        this.imagePane.setVideoFilterDescriptor(other.getVideoFilterDescriptor());
        this.imagePane.updateScreenBorders();
    }

    public ImagePane getImagePane() {
        return this.imagePane;
    }

    public void destroy() {
        Machine machine = App.getMachine();
        if (machine != null && machine.isVsDualSystem()) {
            ((MainCPU)machine.getCPU()).clearScreenRenderer();
        }
        this.imagePane.destroy();
        DualAPU.setMainUpdateEnabled(true);
        this.dispose();
    }

    private void closeFrame() {
        App.destroySubMonitorFrame();
    }

    public void enterFullscreenMode() {
        if (this.imagePane.getBufferStrategy() == null) {
            this.wasMaximized = GuiUtil.isMaximized(this);
            ImageFrame imageFrame = App.getImageFrame();
            if (GuiUtil.sharesGraphicsDevice(imageFrame, this)) {
                GuiUtil.moveToGraphicsDevice(this, GuiUtil.getNextGraphicsDevice(imageFrame));
            }
            GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
            this.dispose();
            GuiUtil.requestVsync(this, false);
            this.setUndecorated(true);
            this.setIgnoreRepaint(true);
            device.setFullScreenWindow(this);
            this.createBufferStrategy(3);
            this.imagePane.setBufferStrategy(this.getBufferStrategy());
            EventQueue.invokeLater(() -> this.setVisible(true));
            EventQueue.invokeLater(this.imagePane::redraw);
        }
    }

    public void exitFullscreenMode() {
        if (this.imagePane.getBufferStrategy() != null) {
            this.imagePane.getBufferStrategy().dispose();
            this.imagePane.setBufferStrategy(null);
            this.dispose();
            this.setUndecorated(false);
            this.setIgnoreRepaint(false);
            if (this.wasMaximized) {
                GuiUtil.maximize(this);
            }
            GuiUtil.requestVsync(this, true);
            EventQueue.invokeLater(() -> this.setVisible(true));
            EventQueue.invokeLater(this.imagePane::redraw);
        }
    }

    public void setScreenScale(int scale) {
        this.exitFullscreenMode();
        Rectangle area = GuiUtil.getScreenWorkingArea(this);
        if (scale << 8 > area.width || 240 * scale > area.height) {
            GuiUtil.maximize(this);
        } else {
            GuiUtil.normalize(this);
            this.imagePane.setScreenScale(scale);
            GuiUtil.maxipack(this);
        }
    }

    public void setUseTvAspectRatio(boolean useTvAspectRatio) {
        if (this.imagePane.isUseTvAspectRatio() != useTvAspectRatio) {
            this.imagePane.setUseTvAspectRatio(useTvAspectRatio);
            GuiUtil.maxipack(this);
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Sub Monitor");
        this.setMinimumSize(null);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                SubMonitorFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SubMonitorFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                SubMonitorFrame.this.formWindowOpened(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void formWindowOpened(WindowEvent evt) {
        GuiUtil.requestVsync(this, true);
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        DualAPU.setMainUpdateEnabled(false);
    }
}

