/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ips;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import nintaco.App;
import nintaco.MessageException;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.files.IpsUtil;
import nintaco.gui.BrowsePanel;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InformationDialog;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.ips.IpsPatchPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class PatchFrame
extends JFrame {
    private final boolean applyIPS;
    private BrowsePanel browsePanel1;
    private BrowsePanel browsePanel2;
    private BrowsePanel browsePanel3;
    private JButton cancelButton;
    private JButton okButton;

    public PatchFrame(boolean applyIPS) {
        this.applyIPS = applyIPS;
        this.initComponents();
        this.initBrowsePanels();
        this.setTitle(applyIPS ? "Apply IPS Patch" : "Create IPS Patch");
        this.enableOkButton();
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        if (this.applyIPS) {
            App.destroyApplyIpsPatchFrame();
        } else {
            App.destroyCreateIpsPatchFrame();
        }
    }

    private void initBrowsePanels() {
        Paths paths = AppPrefs.getInstance().getPaths();
        FileUtil.mkdir(paths.getPatchesDir());
        this.browsePanel1.setFileFilters(ImageFrame.FileExtensionFilters);
        this.browsePanel1.setFileChooserTitle("Select Original File");
        this.browsePanel1.setDefaultDirectory(paths.getFilesDir());
        this.browsePanel1.setSaveDirectoryConsumer((p, d) -> p.setFilesDir((String)d));
        this.browsePanel1.setShowOpenFileChooser(true);
        this.browsePanel2.setShowOpenFileChooser(true);
        this.browsePanel3.setShowOpenFileChooser(false);
        this.browsePanel1.addFileTextFieldEditedListener(this::enableOkButton);
        this.browsePanel2.addFileTextFieldEditedListener(this::enableOkButton);
        this.browsePanel3.addFileTextFieldEditedListener(this::enableOkButton);
        if (this.applyIPS) {
            IpsPatchPrefs prefs = AppPrefs.getInstance().getApplyIpsPatchPrefs();
            this.browsePanel1.setFileName(prefs.getOriginal());
            this.browsePanel2.setFileName(prefs.getPatch());
            this.browsePanel3.setFileName(prefs.getModified());
            this.browsePanel1.setBrowseButtonListener(this::setApplyBrowsePanel3FileName);
            ((TitledBorder)this.browsePanel2.getBorder()).setTitle("Patch File (in)");
            this.browsePanel2.setFileChooserTitle("Select Patch File");
            this.browsePanel2.setFileFilters(new FileExtensionFilter(0, "IPS files (*.ips)", "ips"));
            this.browsePanel2.setDefaultDirectory(paths.getPatchesDir());
            this.browsePanel2.setSaveDirectoryConsumer((p, d) -> p.setPatchesDir((String)d));
            ((TitledBorder)this.browsePanel3.getBorder()).setTitle("Modified File (out)");
            this.browsePanel3.setFileChooserTitle("Select Modified File");
            this.browsePanel3.setFileExtension(null);
            this.browsePanel3.setFileFilters(ImageFrame.FileExtensionFilters);
            this.browsePanel3.setDefaultDirectory(paths.getFilesDir());
            this.browsePanel3.setBrowseButtonListener(this::setApplyBrowsePanel3FileName);
            this.browsePanel3.setSaveDirectoryConsumer((p, d) -> p.setFilesDir((String)d));
        } else {
            IpsPatchPrefs prefs = AppPrefs.getInstance().getCreateIpsPatchPrefs();
            this.browsePanel1.setFileName(prefs.getOriginal());
            this.browsePanel2.setFileName(prefs.getModified());
            this.browsePanel3.setFileName(prefs.getPatch());
            this.browsePanel1.setBrowseButtonListener(this::setCreateBrowsePanel3FileName);
            ((TitledBorder)this.browsePanel2.getBorder()).setTitle("Modified File (in)");
            this.browsePanel2.setFileChooserTitle("Select Modified File");
            this.browsePanel2.setFileFilters(ImageFrame.FileExtensionFilters);
            this.browsePanel2.setDefaultDirectory(paths.getFilesDir());
            this.browsePanel2.setSaveDirectoryConsumer((p, d) -> p.setFilesDir((String)d));
            ((TitledBorder)this.browsePanel3.getBorder()).setTitle("Patch File (out)");
            this.browsePanel3.setFileChooserTitle("Select Patch File");
            this.browsePanel3.setFileExtension("ips");
            this.browsePanel3.setFileFilters(new FileExtensionFilter(0, "IPS files (*.ips)", "ips"));
            this.browsePanel3.setDefaultDirectory(paths.getPatchesDir());
            this.browsePanel2.setSaveDirectoryConsumer((p, d) -> p.setPatchesDir((String)d));
            this.browsePanel3.setBrowseButtonListener(this::setCreateBrowsePanel3FileName);
        }
    }

    private void setApplyBrowsePanel3FileName() {
        if (StringUtil.isBlank(this.browsePanel3.getFileName())) {
            String dir = null;
            String fileName = "modified.nes";
            if (!StringUtil.isBlank(this.browsePanel1.getFileName())) {
                FilePath filePath = FilePath.fromLongString(this.browsePanel1.getFileName());
                String entryName = filePath.getEntryFileName();
                if (!StringUtil.isBlank(entryName)) {
                    fileName = FileUtil.getFileNameWithoutExtension(entryName) + "-modified." + FileUtil.getFileExtension(entryName);
                }
                if (!StringUtil.isBlank(filePath.getArchivePath())) {
                    dir = FileUtil.getDirectoryPath(filePath.getArchivePath());
                } else if (!StringUtil.isBlank(filePath.getEntryPath())) {
                    dir = FileUtil.getDirectoryPath(filePath.getEntryPath());
                }
            }
            if (dir == null) {
                dir = AppPrefs.getInstance().getPaths().getFilesDir();
            }
            this.browsePanel3.setFileName(FileUtil.appendSeparator(dir) + fileName);
        }
    }

    private void setCreateBrowsePanel3FileName() {
        if (StringUtil.isBlank(this.browsePanel3.getFileName())) {
            FilePath filePath;
            String entryName;
            String fileName = "out.ips";
            if (!StringUtil.isBlank(this.browsePanel1.getFileName()) && !StringUtil.isBlank(entryName = (filePath = FilePath.fromLongString(this.browsePanel1.getFileName())).getEntryFileName())) {
                fileName = FileUtil.getFileNameWithoutExtension(entryName) + ".ips";
            }
            this.browsePanel3.setFileName(FileUtil.appendSeparator(AppPrefs.getInstance().getPaths().getPatchesDir()) + fileName);
        }
    }

    private void enableOkButton() {
        this.okButton.setEnabled(!StringUtil.isBlank(this.browsePanel1.getFileName()) && !StringUtil.isBlank(this.browsePanel2.getFileName()) && !StringUtil.isBlank(this.browsePanel3.getFileName()));
    }

    private void processFiles(String fileName1, String fileName2, String fileName3, PleaseWaitDialog pleaseWaitDialog) {
        if (this.applyIPS) {
            this.applyIpsPatch(fileName1, fileName2, fileName3, pleaseWaitDialog);
        } else {
            this.createIpsPatch(fileName1, fileName2, fileName3, pleaseWaitDialog);
        }
    }

    private void applyIpsPatch(String original, String patch, String modified, PleaseWaitDialog pleaseWaitDialog) {
        String errorMessage = null;
        try {
            IpsUtil.applyIPS(original, patch, modified);
        }
        catch (MessageException m) {
            errorMessage = m.getMessage();
        }
        catch (Throwable t) {
            errorMessage = "Failed to apply IPS patch.";
        }
        pleaseWaitDialog.dispose();
        if (errorMessage == null) {
            GuiUtil.invokeAndWait(() -> GuiUtil.displayMessage("Patching Completed", this, "The file was successfully patched.", InformationDialog.IconType.INFORMATION));
            EventQueue.invokeLater(this::closeFrame);
        } else {
            GuiUtil.displayError("Apply IPS Error", this, errorMessage);
        }
        App.setNoStepPause(false);
    }

    private void createIpsPatch(String original, String modified, String patch, PleaseWaitDialog pleaseWaitDialog) {
        String errorMessage = null;
        try {
            IpsUtil.createIPS(original, modified, patch);
        }
        catch (MessageException m) {
            errorMessage = m.getMessage();
        }
        catch (Throwable t) {
            errorMessage = "Failed to create IPS patch.";
        }
        pleaseWaitDialog.dispose();
        if (errorMessage == null) {
            GuiUtil.invokeAndWait(() -> GuiUtil.displayMessage("Patch Creation Completed", this, "The IPS patch was successfully created.", InformationDialog.IconType.INFORMATION));
            EventQueue.invokeLater(this::closeFrame);
        } else {
            GuiUtil.displayError("Create IPS Error", this, errorMessage);
        }
        App.setNoStepPause(false);
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.browsePanel1 = new BrowsePanel(this);
        this.browsePanel2 = new BrowsePanel(this);
        this.browsePanel3 = new BrowsePanel(this);
        this.setDefaultCloseOperation(0);
        this.setTitle("Create IPS Patch");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PatchFrame.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatchFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatchFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.browsePanel1.setBorder(BorderFactory.createTitledBorder("Original File (in)"));
        this.browsePanel2.setBorder(BorderFactory.createTitledBorder("Modified File (in)"));
        this.browsePanel3.setBorder(BorderFactory.createTitledBorder("Patch File (out)"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.browsePanel1, -1, -1, Short.MAX_VALUE).addComponent(this.browsePanel2, -1, -1, Short.MAX_VALUE).addComponent(this.browsePanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.browsePanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browsePanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browsePanel3, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        IpsPatchPrefs prefs;
        String fileName1 = this.browsePanel1.getFileName();
        String fileName2 = this.browsePanel2.getFileName();
        String fileName3 = this.browsePanel3.getFileName();
        if (StringUtil.isBlank(fileName1)) {
            GuiUtil.displayError("Missing Field", this, "Please provide the original file name.");
            return;
        }
        if (StringUtil.isBlank(fileName2)) {
            GuiUtil.displayError("Missing Field", this, "Please provide the %s file name.", this.applyIPS ? "patch" : "modified");
            return;
        }
        if (StringUtil.isBlank(fileName3)) {
            GuiUtil.displayError(this, "Please provide the %s file name.", this.applyIPS ? "modified" : "patch");
            return;
        }
        FilePath filePath1 = FilePath.fromLongString(fileName1);
        if (filePath1 == null) {
            GuiUtil.displayError("Invalid File Name", this, "The original file name is not valid.");
            return;
        }
        if (!new File(filePath1.getOuterPath()).exists()) {
            GuiUtil.displayError("File Not Found", this, "Failed to locate the original file.");
            return;
        }
        FilePath filePath2 = FilePath.fromLongString(fileName2);
        if (filePath2 == null) {
            GuiUtil.displayError("Invalid File Name", this, "The %s file name is not valid.", this.applyIPS ? "patch" : "modified");
        } else if (!new File(filePath2.getOuterPath()).exists()) {
            GuiUtil.displayError("File Not Found", this, "Failed to locate the %s file.", this.applyIPS ? "patch" : "modified");
            return;
        }
        if (!GuiUtil.confirmOverwrite(this, fileName3)) {
            return;
        }
        if (this.applyIPS) {
            prefs = AppPrefs.getInstance().getApplyIpsPatchPrefs();
            prefs.setOriginal(fileName1);
            prefs.setPatch(fileName2);
            prefs.setModified(fileName3);
        } else {
            prefs = AppPrefs.getInstance().getCreateIpsPatchPrefs();
            prefs.setOriginal(fileName1);
            prefs.setModified(fileName2);
            prefs.setPatch(fileName3);
        }
        AppPrefs.save();
        App.setNoStepPause(true);
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        new Thread(() -> this.processFiles(fileName1, fileName2, fileName3, pleaseWaitDialog)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }
}

