/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.mapmaker;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.files.FileUtil;
import nintaco.gui.IntPoint;
import nintaco.gui.mapmaker.MapMakerAppPrefs;
import nintaco.gui.mapmaker.MapMakerGamePrefs;
import nintaco.gui.mapmaker.MapTile;
import nintaco.mappers.Mapper;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class MapMakerFrame
extends JFrame {
    private static final IntPoint[][] ORIGINS = new IntPoint[5][];
    private final int[][] patternTableAddresses = new int[60][64];
    private final int[][] paletteRamIndices = new int[60][64];
    private final IntPoint key = new IntPoint();
    private final IntPoint position = new IntPoint();
    private int[][] screenA = new int[30][32];
    private int[][] screenB = new int[30][32];
    private Map<IntPoint, MapTile> tiles = new HashMap<IntPoint, MapTile>();
    private int fileIndex;
    private String fileFormat;
    private String outputDir;
    private String filePrefix;
    private boolean capturedScreenA;
    private int sprite0Hits;
    private volatile Machine machine;
    private volatile Mapper mapper;
    private volatile PPU ppu;
    private volatile boolean running;
    private volatile int updateScanline;
    private volatile int captureType;
    private volatile int maxDifferences;
    private volatile int trackingSize;
    private volatile int flushDelay;
    private volatile int flushTimer;
    private volatile int startTileRow;
    private volatile int endTileRow;
    private volatile boolean lastStart;
    private volatile boolean paused;
    private volatile boolean resumeRequested;
    private volatile boolean updateOnSprite0Hit;
    private volatile boolean autoFlush;
    private volatile boolean autoPause;
    private volatile IntPoint[] origins;
    private JCheckBox autoFlushCheckBox;
    private JCheckBox autoPauseCheckBox;
    private JButton browseButton;
    private JComboBox captureComboBox;
    private JLabel captureLabel;
    private JButton defaultsButton;
    private JLabel endTileRowLabel;
    private JSpinner endTileRowSpinner;
    private JComboBox fileFormatComboBox;
    private JLabel fileFormatLabel;
    private JLabel filePrefixLabel;
    private JTextField filePrefixTextField;
    private JButton flushButton;
    private JLabel flushDelayLabel;
    private JTextField flushDelayTextField;
    private JLabel maxDiffLabel;
    private JTextField maxDiffTextField;
    private JLabel outputDirLabel;
    private JTextField outputDirTextField;
    private JToggleButton pauseToggleButton;
    private JLabel scanlineLabel;
    private JTextField scanlineTextField;
    private JCheckBox sprite0CheckBox;
    private JLabel startIndexLabel;
    private JTextField startIndexTextField;
    private JLabel startTileRowLabel;
    private JSpinner startTileRowSpinner;
    private JToggleButton startToggleButton;
    private JLabel statusLabel;
    private JComboBox trackingSizeComboBox;
    private JLabel trackingSizeLabel;

    private static IntPoint[] createOrigins(int size) {
        ArrayList<IntPoint> qs = new ArrayList<IntPoint>();
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                if (i == 0 || j == 0) continue;
                qs.add(new IntPoint(i, j));
            }
        }
        Collections.sort(qs, (a, b) -> a.x * a.x + a.y * a.y - (b.x * b.x + b.y * b.y));
        ArrayList<IntPoint> ps = new ArrayList<IntPoint>();
        ps.add(new IntPoint(0, 0));
        for (int i = 1; i <= size; ++i) {
            ps.add(new IntPoint(i, 0));
            ps.add(new IntPoint(-i, 0));
            ps.add(new IntPoint(0, i));
            ps.add(new IntPoint(0, -i));
        }
        ps.addAll(qs);
        IntPoint[] os = new IntPoint[ps.size()];
        ps.toArray(os);
        return os;
    }

    public MapMakerFrame(Machine machine) {
        this.initComponents();
        this.initFileFormatComboBox();
        this.initLoseFocusListeners();
        this.initSpinners();
        this.loadFields();
        this.setMachine(machine);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initSpinners() {
        this.startTileRowSpinner.setModel(new SpinnerNumberModel(0, 0, 29, 1));
        this.startTileRowSpinner.setEditor(new JSpinner.NumberEditor(this.startTileRowSpinner, "#"));
        this.endTileRowSpinner.setModel(new SpinnerNumberModel(29, 0, 29, 1));
        this.endTileRowSpinner.setEditor(new JSpinner.NumberEditor(this.endTileRowSpinner, "#"));
        GuiUtil.addLoseFocusListener((Window)this, this.startTileRowSpinner);
        GuiUtil.addLoseFocusListener((Window)this, this.endTileRowSpinner);
    }

    private synchronized void flush() {
        PPU pp = this.ppu;
        if (pp == null) {
            return;
        }
        Map<IntPoint, MapTile> ts = this.tiles;
        int index = this.fileIndex++;
        new Thread(() -> this.saveImage(pp, ts, index)).start();
        this.tiles = new HashMap<IntPoint, MapTile>();
        this.capturedScreenA = false;
        this.flushTimer = this.flushDelay;
        for (int i = 29; i >= 0; --i) {
            for (int j = 31; j >= 0; --j) {
                this.screenB[i][j] = -1;
                this.screenA[i][j] = -1;
            }
        }
    }

    private void updateStartIndex() {
        if (EventQueue.isDispatchThread()) {
            this.filePrefix = this.filePrefixTextField.getText().trim();
            this.outputDir = this.outputDirTextField.getText().trim();
            String prefix = this.filePrefix;
            String outDir = this.outputDir;
            if (!StringUtil.isBlank(prefix) && !StringUtil.isBlank(outDir)) {
                new Thread(() -> {
                    int index = FileUtil.getSuggestedStartIndex(prefix, outDir);
                    EventQueue.invokeLater(() -> {
                        this.fileIndex = index;
                        this.startIndexTextField.setText(Integer.toString(this.fileIndex));
                    });
                }).start();
            }
        } else {
            EventQueue.invokeLater(this::updateStartIndex);
        }
    }

    private void saveImage(PPU ppu, Map<IntPoint, MapTile> tiles, int fileIndex) {
        File file = null;
        try {
            Machine m = this.machine;
            if (m == null) {
                return;
            }
            int[] palette = PaletteUtil.getExtendedPalette(m);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (IntPoint p : tiles.keySet()) {
                minX = Math.min(minX, p.x);
                maxX = Math.max(maxX, p.x);
                minY = Math.min(minY, p.y);
                maxY = Math.max(maxY, p.y);
            }
            int width = maxX - minX + 1 << 3;
            int height = maxY - minY + 1 << 3;
            FileUtil.mkdir(this.outputDir);
            String fileName = String.format("%s-%03d.%s", this.filePrefix, fileIndex, this.fileFormat);
            file = new File(FileUtil.appendSeparator(this.outputDir) + fileName);
            BufferedImage image = new BufferedImage(width, height, 1);
            int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            for (Map.Entry<IntPoint, MapTile> entry : tiles.entrySet()) {
                IntPoint p = entry.getKey();
                byte[] paletteIndices = entry.getValue().getPaletteIndices();
                int tx = p.x - minX << 3;
                int ty = p.y - minY << 3;
                for (int y = 7; y >= 0; --y) {
                    int offset = (ty | y) * width + tx;
                    int row = y << 3;
                    for (int x = 7; x >= 0; --x) {
                        pixels[offset + x] = palette[paletteIndices[row | x] & 0xFF];
                    }
                }
            }
            ImageIO.write((RenderedImage)image, this.fileFormat, file);
            EventQueue.invokeLater(() -> {
                if (this.running) {
                    this.statusLabel.setText("Saved: " + fileName);
                }
            });
        }
        catch (Throwable t) {
            this.setRunning(false);
            if (file == null) {
                GuiUtil.displayError(this, "Failed to save image file.");
            }
            GuiUtil.displayError(this, "Failed to save '" + file.getPath() + "'.");
        }
    }

    private int compare(IntPoint[] origins, int[][] a, int[][] b) {
        int bestDifferences = 4096;
        int bestIndex = 0;
        for (int i = 0; i < origins.length; ++i) {
            IntPoint o = origins[i];
            int differences = this.compare(a, b, o.x, o.y, bestDifferences);
            if (differences >= bestDifferences) continue;
            bestIndex = i;
            bestDifferences = differences;
            if (differences == 0) break;
        }
        if (this.autoFlush && bestDifferences >= this.maxDifferences) {
            return -1;
        }
        return bestIndex;
    }

    private int compare(int[][] a, int[][] b, int bx, int by, int maxDifferences) {
        int x0 = Math.max(0, bx);
        int y0 = Math.max(0, by);
        int x1 = Math.min(32, bx + 32);
        int y1 = Math.min(30, by + 30);
        int differences = 0;
        for (int y = y0; y < y1; ++y) {
            int[] A = a[y];
            int[] B = b[y - by];
            for (int x = x0; x < x1; ++x) {
                if (A[x] == B[x - bx] || ++differences < maxDifferences) continue;
                return differences;
            }
        }
        return differences;
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroyMapMakerFrame();
    }

    private void initLoseFocusListeners() {
        this.outputDirTextField.addActionListener(e -> {
            this.updateStartIndex();
            this.requestFocusInWindow();
        });
        this.filePrefixTextField.addActionListener(e -> {
            this.updateStartIndex();
            this.requestFocusInWindow();
        });
        GuiUtil.addLoseFocusListener((Window)this, this.startIndexTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.maxDiffTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.scanlineTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.flushDelayTextField);
    }

    private void initFileFormatComboBox() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String format : GuiUtil.getWritableImageFileFormats()) {
            model.addElement(format);
        }
        this.fileFormatComboBox.setModel(model);
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getMapMakerAppPrefs());
    }

    private void loadFields(MapMakerAppPrefs prefs) {
        this.outputDir = AppPrefs.getInstance().getPaths().getMapsDir();
        this.fileFormat = prefs.getFileFormat();
        this.flushDelay = prefs.getFlushDelay();
        this.outputDirTextField.setText(this.outputDir);
        this.fileFormatComboBox.setSelectedItem(this.fileFormat);
        this.flushDelayTextField.setText(Integer.toString(this.flushDelay));
        this.updateStartIndex();
    }

    private void saveFields() {
        if (this.running) {
            this.setRunning(false);
            this.flush();
        }
        GuiUtil.invokeAndWait(this::captureFields);
        this.saveGamePrefs();
        MapMakerAppPrefs prefs = AppPrefs.getInstance().getMapMakerAppPrefs();
        AppPrefs.getInstance().getPaths().setMapsDir(this.outputDir);
        prefs.setFileFormat(this.fileFormat);
        prefs.setFlushDelay(this.flushDelay);
        AppPrefs.save();
    }

    private void resetFields() {
        this.loadFields(new MapMakerAppPrefs());
    }

    private void setSpinnersEnabled(boolean enabled) {
        boolean e = enabled && this.captureComboBox.getSelectedIndex() != 2;
        this.startTileRowLabel.setEnabled(e);
        this.startTileRowSpinner.setEnabled(e);
        this.endTileRowLabel.setEnabled(e);
        this.endTileRowSpinner.setEnabled(e);
    }

    private void loadGamePrefs() {
        this.loadGamePrefs(GamePrefs.getInstance().getMapMakerGamePrefs());
    }

    private void loadGamePrefs(MapMakerGamePrefs prefs) {
        this.setAutoFlush(prefs.isAutoFlush());
        this.autoPause = prefs.isAutoPause();
        this.captureType = prefs.getCaptureType();
        this.filePrefix = StringUtil.isBlank(prefs.getFilePrefix()) ? FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) : prefs.getFilePrefix();
        this.maxDifferences = prefs.getMaxDifferences();
        this.trackingSize = prefs.getTrackingSize();
        this.updateScanline = prefs.getUpdateScanline();
        this.updateOnSprite0Hit = prefs.isUpdateOnSprite0Hit();
        this.startTileRow = prefs.getStartTileRow();
        this.endTileRow = prefs.getEndTileRow();
        EventQueue.invokeLater(() -> {
            this.filePrefixTextField.setText(this.filePrefix);
            this.captureComboBox.setSelectedIndex(this.captureType);
            this.maxDiffTextField.setText(Integer.toString(this.maxDifferences));
            this.trackingSizeComboBox.setSelectedIndex(this.trackingSize - 1);
            this.scanlineTextField.setText(Integer.toString(this.updateScanline));
            this.sprite0CheckBox.setSelected(this.updateOnSprite0Hit);
            this.startTileRowSpinner.setValue(this.startTileRow);
            this.endTileRowSpinner.setValue(this.endTileRow);
            this.setScanlineComponentsEnabled(true);
            this.setSpinnersEnabled(true);
            this.updateStartIndex();
        });
    }

    private void resetGamePrefs() {
        this.loadGamePrefs(new MapMakerGamePrefs());
    }

    private void saveGamePrefs() {
        MapMakerGamePrefs prefs = GamePrefs.getInstance().getMapMakerGamePrefs();
        prefs.setAutoFlush(this.autoFlush);
        prefs.setAutoPause(this.autoPause);
        prefs.setCaptureType(this.captureType);
        prefs.setFilePrefix(this.filePrefix);
        prefs.setMaxDifferences(this.maxDifferences);
        prefs.setTrackingSize(this.trackingSize);
        prefs.setUpdateScanline(this.updateScanline);
        prefs.setUpdateOnSprite0Hit(this.updateOnSprite0Hit);
        prefs.setStartTileRow(this.startTileRow);
        prefs.setEndTileRow(this.endTileRow);
        GamePrefs.save();
    }

    private void setAutoFlush(boolean autoFlush) {
        if (EventQueue.isDispatchThread()) {
            this.autoFlush = autoFlush;
            this.autoFlushCheckBox.setSelected(autoFlush);
            this.maxDiffLabel.setEnabled(autoFlush);
            this.maxDiffTextField.setEnabled(autoFlush);
        } else {
            EventQueue.invokeLater(() -> this.setAutoFlush(autoFlush));
        }
    }

    private void captureFields() {
        this.outputDir = this.outputDirTextField.getText().trim();
        this.filePrefix = this.filePrefixTextField.getText().trim();
        this.fileIndex = GuiUtil.parseTextField(this.startIndexTextField, 0, 0, 999);
        Object format = this.fileFormatComboBox.getSelectedItem();
        this.fileFormat = format == null ? "png" : format.toString();
        this.captureType = this.captureComboBox.getSelectedIndex();
        if (this.captureType < 0) {
            this.captureType = 0;
        }
        this.trackingSize = this.trackingSizeComboBox.getSelectedIndex() + 1;
        if (this.trackingSize == 0) {
            this.trackingSize = 1;
        }
        this.origins = ORIGINS[this.trackingSize - 1];
        this.autoFlush = this.autoFlushCheckBox.isSelected();
        this.autoPause = this.autoPauseCheckBox.isSelected();
        this.maxDifferences = GuiUtil.parseTextField(this.maxDiffTextField, 160, 1, 960);
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        Machine m = this.machine;
        this.updateScanline = GuiUtil.parseTextField(this.scanlineTextField, 0, -1, (m == null ? TVSystem.PAL.getScanlineCount() : m.getMapper().getTVSystem().getScanlineCount()) - 1);
        this.flushDelay = GuiUtil.parseTextField(this.flushDelayTextField, 60, 0, 600);
        this.startTileRow = (Integer)this.startTileRowSpinner.getValue();
        this.endTileRow = (Integer)this.endTileRowSpinner.getValue();
        if (this.endTileRow < this.startTileRow) {
            int temp = this.startTileRow;
            this.startTileRow = this.endTileRow;
            this.endTileRow = temp;
            this.startTileRowSpinner.setValue(this.startTileRow);
            this.endTileRowSpinner.setValue(this.endTileRow);
        }
    }

    private void enableComponents() {
        Machine m = this.machine;
        boolean run = m != null && this.running;
        this.startToggleButton.setEnabled(m != null);
        this.startToggleButton.setSelected(run);
        this.startToggleButton.setText(run ? "Stop" : "Start");
        this.flushButton.setEnabled(run);
        this.pauseToggleButton.setEnabled(run);
        boolean enabled = m != null && !run;
        this.outputDirLabel.setEnabled(enabled);
        this.outputDirTextField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.filePrefixLabel.setEnabled(enabled);
        this.filePrefixTextField.setEnabled(enabled);
        this.startIndexLabel.setEnabled(enabled);
        this.startIndexTextField.setEnabled(enabled);
        this.fileFormatLabel.setEnabled(enabled);
        this.fileFormatComboBox.setEnabled(enabled);
        this.captureLabel.setEnabled(enabled);
        this.captureComboBox.setEnabled(enabled);
        this.trackingSizeLabel.setEnabled(enabled);
        this.trackingSizeComboBox.setEnabled(enabled);
        this.autoFlushCheckBox.setEnabled(enabled);
        this.maxDiffLabel.setEnabled(enabled);
        this.maxDiffTextField.setEnabled(enabled);
        this.sprite0CheckBox.setEnabled(enabled);
        this.flushDelayLabel.setEnabled(enabled);
        this.flushDelayTextField.setEnabled(enabled);
        this.autoPauseCheckBox.setEnabled(enabled);
        this.defaultsButton.setEnabled(enabled);
        this.setScanlineComponentsEnabled(enabled);
        this.setSpinnersEnabled(enabled);
        this.statusLabel.setText(" ");
        if (m == null) {
            this.filePrefixTextField.setText("");
        }
    }

    private void setRunning(boolean running) {
        if (EventQueue.isDispatchThread()) {
            if (!running && this.autoFlush) {
                this.flush();
            }
            if (!running) {
                this.setPaused(false);
                this.lastStart = false;
                this.startIndexTextField.setText(Integer.toString(this.fileIndex));
            }
            this.flushTimer = 0;
            this.running = running;
            this.enableComponents();
        } else {
            EventQueue.invokeLater(() -> this.setRunning(running));
        }
    }

    private void setScanlineComponentsEnabled(boolean enabled) {
        boolean e = enabled && !this.sprite0CheckBox.isSelected();
        this.scanlineLabel.setEnabled(e);
        this.scanlineTextField.setEnabled(e);
    }

    public final void setMachine(Machine machine) {
        if (this.running) {
            this.setRunning(false);
            this.flush();
        }
        this.machine = machine;
        if (machine == null) {
            this.ppu = null;
            this.mapper = null;
        } else {
            this.ppu = machine.getPPU();
            this.mapper = machine.getMapper();
            this.loadGamePrefs();
        }
        EventQueue.invokeLater(this::enableComponents);
    }

    public void update(int scanline) {
        if (!this.running) {
            return;
        }
        PPU pp = this.ppu;
        Mapper m = this.mapper;
        if (m == null || pp == null) {
            return;
        }
        if (this.updateOnSprite0Hit) {
            if (!pp.isSprite0Hit()) {
                this.sprite0Hits = 0;
                return;
            }
            if (++this.sprite0Hits != 2) {
                return;
            }
        } else if (scanline != this.updateScanline) {
            return;
        }
        if (this.autoPause) {
            boolean start;
            boolean bl = start = (m.getButtons() & 0x8080808) != 0;
            if (!this.lastStart && start) {
                if (this.paused) {
                    this.resumeRequested = true;
                } else {
                    this.setPaused(true);
                }
            }
            this.lastStart = start;
        }
        if (this.flushTimer > 0) {
            --this.flushTimer;
            return;
        }
        int backgroundPatternTableAddress = pp.getBackgroundPatternTableAddress();
        this.readNametable(pp, 8192, backgroundPatternTableAddress, 0, 0);
        this.readNametable(pp, 9216, backgroundPatternTableAddress, 32, 0);
        this.readNametable(pp, 10240, backgroundPatternTableAddress, 0, 30);
        this.readNametable(pp, 11264, backgroundPatternTableAddress, 32, 30);
        int tileX = pp.getScrollX() >> 3;
        int scrollY = pp.getScrollY() - scanline;
        if (scrollY >= 480) {
            scrollY -= 480;
        } else if (scrollY < 0) {
            scrollY += 480;
        }
        int tileY = scrollY >> 3;
        if (this.capturedScreenA) {
            this.copyNametables(tileX, tileY, this.screenB);
            IntPoint[] orgs = this.origins;
            int index = this.compare(orgs, this.screenA, this.screenB);
            if (this.paused && this.resumeRequested && index >= 0) {
                this.resumeRequested = false;
                this.setPaused(false);
            }
            if (!this.paused) {
                if (index > 0) {
                    int[][] temp = this.screenA;
                    this.screenA = this.screenB;
                    this.screenB = temp;
                    IntPoint delta = orgs[index];
                    this.position.translate(delta);
                    this.snapshotPatternTables(pp, tileX, tileY, this.position);
                } else if (index < 0) {
                    this.flush();
                }
            }
        } else {
            this.position.setX(0);
            this.position.setY(0);
            this.copyNametables(tileX, tileY, this.screenA);
            this.snapshotPatternTables(pp, tileX, tileY, this.position);
            this.capturedScreenA = true;
        }
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
        if (paused) {
            EventQueue.invokeLater(() -> {
                this.pauseToggleButton.setSelected(true);
                this.pauseToggleButton.setMnemonic('R');
                this.pauseToggleButton.setText("Resume");
            });
        } else {
            EventQueue.invokeLater(() -> {
                this.pauseToggleButton.setSelected(false);
                this.pauseToggleButton.setMnemonic('P');
                this.pauseToggleButton.setText("Pause");
            });
        }
    }

    private void copyNametables(int tileX, int tileY, int[][] copy) {
        for (int y = 29; y >= 0; --y) {
            int[] c = copy[y];
            int Y = tileY + y;
            if (Y >= 60) {
                Y -= 60;
            }
            int[] addresses = this.patternTableAddresses[Y];
            for (int x = 31; x >= 0; --x) {
                int X = tileX + x;
                if (X >= 64) {
                    X -= 64;
                }
                c[x] = addresses[X];
            }
        }
    }

    private void readNametable(PPU ppu, int address, int backgroundPatternTableAddress, int px, int py) {
        int tileX;
        int tileY;
        int attributeAddress = address | 0x3C0;
        for (tileY = 0; tileY < 30; tileY += 4) {
            tileX = 0;
            while (tileX < 32) {
                int attribute = ppu.peekVRAM(attributeAddress);
                for (int y = 0; y < 4; y += 2) {
                    int yOffset = tileY | y;
                    for (int x = 0; x < 4; x += 2) {
                        int Y;
                        int xOffset = tileX | x;
                        int paletteRamIndex = (attribute & 3) << 2;
                        attribute >>= 2;
                        for (int i = 0; i < 2 && (Y = yOffset | i) < 30; ++i) {
                            int[] indices = this.paletteRamIndices[Y + py];
                            for (int j = 0; j < 2; ++j) {
                                indices[px + (xOffset | j)] = paletteRamIndex;
                            }
                        }
                    }
                }
                tileX += 4;
                ++attributeAddress;
            }
        }
        for (tileY = 0; tileY < 30; ++tileY) {
            int[] addresses = this.patternTableAddresses[py + tileY];
            tileX = 0;
            while (tileX < 32) {
                addresses[px + tileX] = backgroundPatternTableAddress | ppu.peekVRAM(address) << 4;
                ++tileX;
                ++address;
            }
        }
    }

    private void snapshotPatternTables(PPU ppu, int tileX, int tileY, IntPoint position) {
        int Px = position.x;
        int Py = position.y;
        if ((tileX & 1) == 1) {
            --tileX;
            --Px;
        }
        if ((tileY & 1) == 1) {
            --tileY;
            --Py;
        }
        int yMin = 0;
        int yMax = 0;
        int xMin = 0;
        int xMax = 0;
        int edgeMinY = 0;
        int edgeMaxY = 0;
        int edgeMinX = 0;
        int edgeMaxX = 0;
        switch (this.captureType) {
            case 0: {
                xMin = tileX;
                xMax = tileX + 32;
                yMin = tileY + this.startTileRow;
                yMax = tileY + this.endTileRow + 1;
                edgeMinX = tileX + 2;
                edgeMaxX = tileX + 29;
                edgeMinY = tileY + 2;
                edgeMaxY = tileY + 27;
                break;
            }
            case 1: {
                xMin = 0;
                xMax = 64;
                yMin = tileY + this.startTileRow;
                yMax = tileY + this.endTileRow + 1;
                edgeMinX = 0;
                edgeMaxX = 64;
                edgeMinY = tileY + 2;
                edgeMaxY = tileY + 27;
                break;
            }
            case 2: {
                xMin = tileX;
                xMax = tileX + 32;
                yMin = 0;
                yMax = 60;
                edgeMinX = tileX + 2;
                edgeMaxX = tileX + 29;
                edgeMinY = 0;
                edgeMaxY = 60;
            }
        }
        for (int i = yMin; i < yMax; ++i) {
            boolean edgeTileY = i < edgeMinY || i > edgeMaxY;
            int Y = i;
            if (Y >= 60) {
                Y -= 60;
            }
            int[] addresses = this.patternTableAddresses[Y];
            int[] indices = this.paletteRamIndices[Y];
            int py = Py + i - tileY;
            for (int j = xMin; j < xMax; ++j) {
                byte[] paletteIndices;
                boolean edgeTile = edgeTileY || j < edgeMinX || j > edgeMaxX;
                this.key.x = Px + j - tileX;
                this.key.y = py;
                MapTile tile = this.tiles.get(this.key);
                if (tile != null && (edgeTile || !tile.isEdgeTile())) continue;
                if (tile == null) {
                    tile = new MapTile();
                    paletteIndices = new byte[64];
                    tile.setPaletteIndices(paletteIndices);
                } else {
                    paletteIndices = tile.getPaletteIndices();
                }
                tile.setEdgeTile(edgeTile);
                this.tiles.put(new IntPoint(this.key), tile);
                int X = j;
                if (X >= 64) {
                    X -= 64;
                }
                int address0 = addresses[X];
                int address1 = address0 + 8;
                int index = indices[X];
                for (int y = 0; y < 8; ++y) {
                    int row = y << 3;
                    int b0 = ppu.peekVRAM(address0 + y);
                    int b1 = ppu.peekVRAM(address1 + y);
                    for (int x = 0; x < 8; ++x) {
                        int shift = 7 - x;
                        paletteIndices[row | x] = (byte)ppu.getPaletteRamValue(index | (b1 >> shift & 1) << 1 | b0 >> shift & 1);
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.startToggleButton = new JToggleButton();
        this.sprite0CheckBox = new JCheckBox();
        this.scanlineLabel = new JLabel();
        this.scanlineTextField = new JTextField();
        this.captureLabel = new JLabel();
        this.captureComboBox = new JComboBox();
        this.trackingSizeLabel = new JLabel();
        this.trackingSizeComboBox = new JComboBox();
        this.fileFormatLabel = new JLabel();
        this.fileFormatComboBox = new JComboBox();
        this.outputDirLabel = new JLabel();
        this.outputDirTextField = new JTextField();
        this.browseButton = new JButton();
        this.filePrefixLabel = new JLabel();
        this.filePrefixTextField = new JTextField();
        this.startIndexLabel = new JLabel();
        this.startIndexTextField = new JTextField();
        this.flushButton = new JButton();
        this.maxDiffLabel = new JLabel();
        this.maxDiffTextField = new JTextField();
        this.autoFlushCheckBox = new JCheckBox();
        this.statusLabel = new JLabel();
        this.flushDelayLabel = new JLabel();
        this.flushDelayTextField = new JTextField();
        this.pauseToggleButton = new JToggleButton();
        this.autoPauseCheckBox = new JCheckBox();
        this.startTileRowLabel = new JLabel();
        this.startTileRowSpinner = new JSpinner();
        this.endTileRowLabel = new JLabel();
        this.endTileRowSpinner = new JSpinner();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Map Maker");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MapMakerFrame.this.formWindowClosing(evt);
            }
        });
        this.startToggleButton.setMnemonic('S');
        this.startToggleButton.setText("Start");
        this.startToggleButton.setEnabled(false);
        this.startToggleButton.setFocusPainted(false);
        this.startToggleButton.setName("");
        this.startToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.startToggleButtonActionPerformed(evt);
            }
        });
        this.sprite0CheckBox.setText("Update on sprite 0 hit");
        this.sprite0CheckBox.setFocusPainted(false);
        this.sprite0CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.sprite0CheckBoxActionPerformed(evt);
            }
        });
        this.scanlineLabel.setText("Update on scanline:");
        this.scanlineLabel.setMaximumSize(null);
        this.scanlineLabel.setMinimumSize(null);
        this.scanlineLabel.setPreferredSize(null);
        this.scanlineTextField.setColumns(4);
        this.scanlineTextField.setText("0");
        this.scanlineTextField.setMaximumSize(null);
        this.scanlineTextField.setMinimumSize(null);
        this.scanlineTextField.setPreferredSize(null);
        this.captureLabel.setText("Capture:");
        this.captureLabel.setMaximumSize(null);
        this.captureLabel.setMinimumSize(null);
        this.captureLabel.setPreferredSize(null);
        this.captureComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Visible Window", "Horizontal Band", "Vertical Band"}));
        this.captureComboBox.setFocusable(false);
        this.captureComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.captureComboBoxActionPerformed(evt);
            }
        });
        this.trackingSizeLabel.setText("Tracking size:");
        this.trackingSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        this.trackingSizeComboBox.setSelectedIndex(1);
        this.trackingSizeComboBox.setFocusable(false);
        this.trackingSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.trackingSizeComboBoxActionPerformed(evt);
            }
        });
        this.fileFormatLabel.setText("File format:");
        this.fileFormatLabel.setMaximumSize(null);
        this.fileFormatLabel.setMinimumSize(null);
        this.fileFormatLabel.setPreferredSize(null);
        this.fileFormatComboBox.setFocusable(false);
        this.fileFormatComboBox.setMaximumSize(null);
        this.fileFormatComboBox.setMinimumSize(null);
        this.fileFormatComboBox.setPreferredSize(null);
        this.outputDirLabel.setText("Output directory:");
        this.outputDirLabel.setMaximumSize(null);
        this.outputDirLabel.setMinimumSize(null);
        this.outputDirLabel.setPreferredSize(null);
        this.outputDirTextField.setMaximumSize(null);
        this.outputDirTextField.setMinimumSize(null);
        this.outputDirTextField.setPreferredSize(null);
        this.browseButton.setMnemonic('B');
        this.browseButton.setText("Browse...");
        this.browseButton.setFocusPainted(false);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.browseButtonActionPerformed(evt);
            }
        });
        this.filePrefixLabel.setText("File prefix:");
        this.filePrefixTextField.setMaximumSize(null);
        this.filePrefixTextField.setMinimumSize(null);
        this.filePrefixTextField.setPreferredSize(null);
        this.startIndexLabel.setText("Start index:");
        this.startIndexTextField.setColumns(4);
        this.startIndexTextField.setText("0");
        this.flushButton.setMnemonic('F');
        this.flushButton.setText("   Flush   ");
        this.flushButton.setEnabled(false);
        this.flushButton.setFocusPainted(false);
        this.flushButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.flushButtonActionPerformed(evt);
            }
        });
        this.maxDiffLabel.setText("Max differences:");
        this.maxDiffTextField.setColumns(4);
        this.maxDiffTextField.setText("160");
        this.autoFlushCheckBox.setSelected(true);
        this.autoFlushCheckBox.setText("Auto flush");
        this.autoFlushCheckBox.setFocusPainted(false);
        this.autoFlushCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.autoFlushCheckBoxActionPerformed(evt);
            }
        });
        this.statusLabel.setText(" ");
        this.flushDelayLabel.setText("Post flush frames:");
        this.flushDelayTextField.setColumns(4);
        this.flushDelayTextField.setText("60");
        this.flushDelayTextField.setMaximumSize(null);
        this.flushDelayTextField.setMinimumSize(null);
        this.flushDelayTextField.setPreferredSize(null);
        this.pauseToggleButton.setText("Pause");
        this.pauseToggleButton.setEnabled(false);
        this.pauseToggleButton.setFocusPainted(false);
        this.pauseToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.pauseToggleButtonActionPerformed(evt);
            }
        });
        this.autoPauseCheckBox.setSelected(true);
        this.autoPauseCheckBox.setText("Auto pause");
        this.autoPauseCheckBox.setFocusPainted(false);
        this.autoPauseCheckBox.setMaximumSize(null);
        this.autoPauseCheckBox.setMinimumSize(null);
        this.autoPauseCheckBox.setPreferredSize(null);
        this.autoPauseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.autoPauseCheckBoxActionPerformed(evt);
            }
        });
        this.startTileRowLabel.setText("Start tile row:");
        this.startTileRowLabel.setMaximumSize(null);
        this.startTileRowLabel.setMinimumSize(null);
        this.startTileRowLabel.setPreferredSize(null);
        this.startTileRowSpinner.setMaximumSize(null);
        this.startTileRowSpinner.setMinimumSize(null);
        this.startTileRowSpinner.setPreferredSize(null);
        this.endTileRowLabel.setText("End tile row:");
        this.endTileRowLabel.setMaximumSize(null);
        this.endTileRowLabel.setMinimumSize(null);
        this.endTileRowLabel.setPreferredSize(null);
        this.endTileRowSpinner.setMaximumSize(null);
        this.endTileRowSpinner.setMinimumSize(null);
        this.endTileRowSpinner.setPreferredSize(null);
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.setMaximumSize(null);
        this.defaultsButton.setMinimumSize(null);
        this.defaultsButton.setPreferredSize(null);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapMakerFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.defaultsButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pauseToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flushButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startToggleButton)).addGroup(layout.createSequentialGroup().addComponent(this.outputDirLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputDirTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addComponent(this.filePrefixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePrefixTextField, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.startIndexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startIndexTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.fileFormatLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileFormatComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.captureLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.captureComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.startTileRowLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startTileRowSpinner, -2, -1, -2).addGap(18, 18, 18).addComponent(this.endTileRowLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endTileRowSpinner, -2, -1, -2).addGap(18, 18, 18).addComponent(this.trackingSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trackingSizeComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.maxDiffLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxDiffTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.sprite0CheckBox).addGap(18, 18, 18).addComponent(this.scanlineLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.autoPauseCheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.autoFlushCheckBox).addGap(18, 18, 18).addComponent(this.flushDelayLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flushDelayTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.defaultsButton, this.flushButton, this.pauseToggleButton, this.startToggleButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.outputDirTextField, -2, -1, -2).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.outputDirLabel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filePrefixLabel).addComponent(this.filePrefixTextField, -2, -1, -2).addComponent(this.startIndexLabel).addComponent(this.startIndexTextField, -2, -1, -2).addComponent(this.fileFormatLabel, -2, -1, -2).addComponent(this.fileFormatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.captureLabel, -2, -1, -2).addComponent(this.captureComboBox, -2, -1, -2).addComponent(this.startTileRowLabel, -2, -1, -2).addComponent(this.startTileRowSpinner, -2, -1, -2).addComponent(this.endTileRowLabel, -2, -1, -2).addComponent(this.endTileRowSpinner, -2, -1, -2).addComponent(this.trackingSizeLabel).addComponent(this.trackingSizeComboBox, -2, -1, -2).addComponent(this.maxDiffLabel).addComponent(this.maxDiffTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sprite0CheckBox).addComponent(this.scanlineLabel, -2, -1, -2).addComponent(this.scanlineTextField, -2, -1, -2).addComponent(this.autoFlushCheckBox).addComponent(this.flushDelayLabel).addComponent(this.flushDelayTextField, -2, -1, -2).addComponent(this.autoPauseCheckBox, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusLabel).addComponent(this.flushButton).addComponent(this.startToggleButton).addComponent(this.pauseToggleButton).addComponent(this.defaultsButton, -2, -1, -2)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void startToggleButtonActionPerformed(ActionEvent evt) {
        if (this.startToggleButton.isSelected()) {
            this.statusLabel.setText(" ");
            this.saveFields();
            this.setRunning(true);
        } else {
            this.setRunning(false);
        }
    }

    private void sprite0CheckBoxActionPerformed(ActionEvent evt) {
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        this.setScanlineComponentsEnabled(true);
    }

    private void captureComboBoxActionPerformed(ActionEvent evt) {
        int index = this.captureComboBox.getSelectedIndex();
        if (index >= 0) {
            this.captureType = index;
        }
        this.setSpinnersEnabled(true);
    }

    private void flushButtonActionPerformed(ActionEvent evt) {
        this.flush();
    }

    private void autoFlushCheckBoxActionPerformed(ActionEvent evt) {
        this.setAutoFlush(this.autoFlushCheckBox.isSelected());
    }

    private void trackingSizeComboBoxActionPerformed(ActionEvent evt) {
        int index = this.trackingSizeComboBox.getSelectedIndex();
        if (index >= 0) {
            this.trackingSize = index + 1;
            this.origins = ORIGINS[index];
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file;
        File dir;
        String outDir = this.outputDirTextField.getText().trim();
        if (StringUtil.isBlank(outDir)) {
            outDir = this.outputDir;
        }
        if ((dir = FileUtil.findExistingParent(outDir)) == null) {
            dir = new File(".");
        }
        JFileChooser chooser = GuiUtil.createFileChooser("Choose Output Directory", dir, new FileFilter[0]);
        chooser.setFileSelectionMode(1);
        if (GuiUtil.showOpenDialog(this, chooser) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.outputDir = file.getPath();
            this.outputDirTextField.setText(this.outputDir);
            this.updateStartIndex();
        }
    }

    private void pauseToggleButtonActionPerformed(ActionEvent evt) {
        this.setPaused(this.pauseToggleButton.isSelected());
    }

    private void autoPauseCheckBoxActionPerformed(ActionEvent evt) {
        this.autoPause = this.autoPauseCheckBox.isSelected();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.resetFields();
        this.resetGamePrefs();
    }

    static {
        for (int i = ORIGINS.length - 1; i >= 0; --i) {
            MapMakerFrame.ORIGINS[i] = MapMakerFrame.createOrigins(i + 1);
        }
    }
}

