/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.nsf;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.gui.nsf.NsfPrefs;
import nintaco.input.InputUtil;
import nintaco.input.other.SetNsfOptions;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class NsfOptionsDialog
extends JDialog {
    private JButton cancelButton;
    private JButton defaultsButton;
    private JLabel minutesLabel;
    private JButton okButton;
    private JCheckBox playInBackgroundCheckBox;
    private JLabel secondsLabel;
    private JCheckBox silenceCheckBox;
    private JSpinner silenceSpinner;
    private JCheckBox trackLengthCheckBox;
    private JSpinner trackLengthSpinner;

    public NsfOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initSpinners();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initSpinners() {
        this.silenceSpinner.setModel(new SpinnerNumberModel(1, 1, 99, 1));
        this.silenceSpinner.setEditor(new JSpinner.NumberEditor(this.silenceSpinner, "#"));
        this.trackLengthSpinner.setModel(new SpinnerNumberModel(1, 1, 99, 1));
        this.trackLengthSpinner.setEditor(new JSpinner.NumberEditor(this.trackLengthSpinner, "#"));
        GuiUtil.addLoseFocusListener((Window)this, this.silenceSpinner);
        GuiUtil.addLoseFocusListener((Window)this, this.trackLengthSpinner);
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getNsfPrefs());
    }

    private void loadFields(NsfPrefs prefs) {
        this.silenceSpinner.setValue(prefs.getSilenceSeconds());
        this.trackLengthSpinner.setValue(prefs.getTrackLengthMinutes());
        this.silenceCheckBox.setSelected(prefs.isAutomaticallyAdvanceTrack());
        this.trackLengthCheckBox.setSelected(prefs.isDefaultTrackLength());
        this.playInBackgroundCheckBox.setSelected(prefs.isPlayInBackground());
        this.enableComponents();
    }

    private void saveFields() {
        NsfPrefs prefs = AppPrefs.getInstance().getNsfPrefs();
        prefs.setSilenceSeconds((Integer)this.silenceSpinner.getValue());
        prefs.setTrackLengthMinutes((Integer)this.trackLengthSpinner.getValue());
        prefs.setAutomaticallyAdvanceTrack(this.silenceCheckBox.isSelected());
        prefs.setDefaultTrackLength(this.trackLengthCheckBox.isSelected());
        prefs.setPlayInBackground(this.playInBackgroundCheckBox.isSelected());
        InputUtil.addOtherInput(new SetNsfOptions(prefs.isAutomaticallyAdvanceTrack(), prefs.getSilenceSeconds(), prefs.isDefaultTrackLength(), prefs.getTrackLengthMinutes()));
        AppPrefs.save();
    }

    private void enableComponents() {
        this.silenceSpinner.setEnabled(this.silenceCheckBox.isSelected());
        this.trackLengthSpinner.setEnabled(this.trackLengthCheckBox.isSelected());
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.trackLengthSpinner = new JSpinner();
        this.silenceCheckBox = new JCheckBox();
        this.playInBackgroundCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.silenceSpinner = new JSpinner();
        this.secondsLabel = new JLabel();
        this.trackLengthCheckBox = new JCheckBox();
        this.minutesLabel = new JLabel();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("NSF Options");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NsfOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.trackLengthSpinner.setModel(new SpinnerNumberModel());
        this.trackLengthSpinner.setEditor(new JSpinner.NumberEditor(this.trackLengthSpinner, ""));
        this.silenceCheckBox.setText("Automatically advance track after");
        this.silenceCheckBox.setFocusPainted(false);
        this.silenceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfOptionsDialog.this.silenceCheckBoxActionPerformed(evt);
            }
        });
        this.playInBackgroundCheckBox.setText("Play in background");
        this.playInBackgroundCheckBox.setFocusPainted(false);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.secondsLabel.setText("seconds of silence");
        this.trackLengthCheckBox.setText("Default track length to");
        this.trackLengthCheckBox.setFocusPainted(false);
        this.trackLengthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfOptionsDialog.this.trackLengthCheckBoxActionPerformed(evt);
            }
        });
        this.minutesLabel.setText("minutes");
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfOptionsDialog.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.trackLengthCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trackLengthSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minutesLabel)).addComponent(this.playInBackgroundCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.silenceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.silenceSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondsLabel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.cancelButton, this.defaultsButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.playInBackgroundCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.silenceCheckBox).addComponent(this.silenceSpinner, -2, -1, -2).addComponent(this.secondsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trackLengthCheckBox).addComponent(this.trackLengthSpinner, -2, -1, -2).addComponent(this.minutesLabel)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void silenceCheckBoxActionPerformed(ActionEvent evt) {
        this.enableComponents();
    }

    private void trackLengthCheckBoxActionPerformed(ActionEvent evt) {
        this.enableComponents();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new NsfPrefs());
    }
}

