/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import nintaco.gui.rob.RobState;

public abstract class RobPane
extends JComponent {
    private static final int IDEAL_WIDTH = 1260;
    private static final int IDEAL_HEIGHT = 554;
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color ROB_FACE = Color.BLACK;
    private static final Color ROB_LINES = new Color(11176848);
    private static final Color ROB_EYES = new Color(9902134);
    private static final Color ROB_DARK_EYES = new Color(8459814);
    private static final Color ROB_REFLECTION = new Color(14723494);
    private static final Color ROB_LIT_EYES = new Color(0xFF7F7F);
    private static final Color ROB_LIT_DARK_EYES = Color.WHITE;
    private static final Color ROB_HIGHLIGHT = new Color(0xEDDEE5);
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private static final int[][][] HIGHLIGHT_POLYGONS = new int[][][]{new int[][]{{5, 7, 20, 13}, {3, 2, 4, 8}}, new int[][]{{97, 95, 82, 89}, {3, 2, 4, 8}}, new int[][]{{5, 7, 20, 13}, {41, 42, 41, 37}}, new int[][]{{97, 95, 82, 89}, {41, 42, 41, 37}}};
    protected final RobState state = new RobState();
    protected double translateX;
    protected double translateY;
    protected double scale;
    protected int paneWidth;
    protected int paneHeight;

    public RobPane() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RobPane.this.paneResized();
            }
        });
        this.setPreferredSize(new Dimension(630, 277));
    }

    private void paneResized() {
        this.paneWidth = this.getWidth();
        this.paneHeight = this.getHeight();
        if (554 * this.paneWidth >= 1260 * this.paneHeight) {
            double width = (double)(this.paneHeight * 1260) / 554.0;
            this.translateX = ((double)this.paneWidth - width) / 2.0;
            this.translateY = 0.0;
            this.scale = width / 1260.0;
        } else {
            double height = this.paneWidth * 554 / 1260;
            this.translateX = 0.0;
            this.translateY = ((double)this.paneHeight - height) / 2.0;
            this.scale = height / 554.0;
        }
        this.repaint();
    }

    protected double convertX(double x) {
        return 630.0 + 230.0 * x;
    }

    protected double convertY(double y) {
        return 310.0 + 40.0 * y;
    }

    public void render(RobState state) {
        if (this.state.modifications != state.modifications) {
            this.state.init(state);
            EventQueue.invokeLater(this::repaint);
        }
    }

    protected void drawROB(Graphics2D g, double x, double y, boolean lit) {
        int i;
        AffineTransform transform = g.getTransform();
        g.translate(x - 102.0, y);
        g.scale(2.0, 2.0);
        g.setColor(ROB_FACE);
        g.fillRoundRect(0, 0, 102, 44, 18, 18);
        g.setColor(ROB_HIGHLIGHT);
        for (i = HIGHLIGHT_POLYGONS.length - 1; i >= 0; --i) {
            g.fillPolygon(HIGHLIGHT_POLYGONS[i][0], HIGHLIGHT_POLYGONS[i][1], 4);
        }
        g.setColor(ROB_LINES);
        g.fillRoundRect(9, 5, 84, 35, 35, 35);
        g.setColor(ROB_FACE);
        for (i = 4; i >= 0; --i) {
            g.fillRect(28, 11 + 5 * i, 48, 4);
        }
        g.setColor(lit ? ROB_LIT_EYES : ROB_EYES);
        g.fillOval(12, 7, 30, 30);
        g.fillOval(60, 7, 30, 30);
        g.setColor(lit ? ROB_LIT_DARK_EYES : ROB_DARK_EYES);
        g.fillOval(17, 12, 20, 20);
        g.fillOval(65, 12, 20, 20);
        g.setColor(ROB_FACE);
        g.drawOval(12, 7, 30, 30);
        g.drawOval(60, 7, 30, 30);
        g.setColor(ROB_LINES);
        g.drawOval(11, 6, 32, 32);
        g.drawOval(59, 6, 32, 32);
        if (!lit) {
            g.setColor(ROB_REFLECTION);
            g.fillRoundRect(21, 16, 12, 12, 6, 6);
            g.fillRoundRect(69, 16, 12, 12, 6, 6);
        }
        g.setTransform(transform);
    }

    @Override
    protected void paintComponent(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        AffineTransform transform = g.getTransform();
        RenderingHints hints = g.getRenderingHints();
        Stroke stroke = g.getStroke();
        g.setStroke(STROKE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(BACKGROUND);
        g.fillRect(0, 0, this.paneWidth, this.paneHeight);
        g.translate(this.translateX, this.translateY);
        g.scale(this.scale, this.scale);
        this.draw(g);
        g.setTransform(transform);
        g.setRenderingHints(hints);
        g.setStroke(stroke);
    }

    protected abstract void draw(Graphics2D var1);
}

