/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import nintaco.gui.rob.RobPane;

public class StackUpPane
extends RobPane {
    public static final Color[] BLOCK_COLORS = new Color[]{new Color(16719703), new Color(0xCCC5CA), new Color(1926829), new Color(16496710), new Color(5155437)};
    private static final Color PLATFORM = new Color(11708582);
    private static final Color HANDS = new Color(10722741);
    private static final int[][] BLOCK_POLYGON = new int[][]{{50, 50, -50, -50, -25, -12, 12, 25}, {0, -40, -40, 0, 0, 20, 20, 0}};
    private static final boolean[] notDrawn = new boolean[5];

    public StackUpPane() {
        this.state.game = 2;
        this.state.reset();
    }

    private void drawHands(Graphics2D g) {
        AffineTransform transform = g.getTransform();
        g.translate(this.convertX(this.state.handsX), this.convertY(this.state.handsY));
        int open = (int)(50.0f + this.state.handsOpen * 30.0f);
        g.setColor(Color.BLACK);
        g.fillRect(open, -33, 6, 26);
        g.fillRect(-open - 6, -33, 6, 26);
        g.setColor(HANDS);
        g.fillRect(open + 6, -35, 63, 30);
        g.fillRect(-open - 69, -35, 63, 30);
        g.setTransform(transform);
    }

    private void drawPlatform(Graphics2D g, double x) {
        g.setColor(PLATFORM);
        int X = (int)this.convertX(x);
        int Y = (int)this.convertY(5.0);
        g.fillRect(X - 63, Y, 126, 6);
        g.fillRect(X - 50, Y, 100, 30);
    }

    private void drawPlatforms(Graphics2D g) {
        for (int i = 4; i >= 0; --i) {
            this.drawPlatform(g, i - 2);
        }
    }

    private void drawBlock(Graphics2D g, double x, double y, Color color) {
        AffineTransform transform = g.getTransform();
        g.translate(this.convertX(x), this.convertY(y));
        g.setColor(color);
        g.fillPolygon(BLOCK_POLYGON[0], BLOCK_POLYGON[1], BLOCK_POLYGON[0].length);
        g.setTransform(transform);
    }

    private void drawBlocks(Graphics2D g) {
        Arrays.fill(notDrawn, true);
        float[][] blocks = this.state.pieces;
        for (int i = 4; i >= 0; --i) {
            float minValue = Float.MAX_VALUE;
            int minIndex = 0;
            for (int j = 4; j >= 0; --j) {
                if (!notDrawn[j] || !(blocks[j][1] < minValue)) continue;
                minValue = blocks[j][1];
                minIndex = j;
            }
            this.drawBlock(g, blocks[minIndex][0], blocks[minIndex][1], BLOCK_COLORS[minIndex]);
            StackUpPane.notDrawn[minIndex] = false;
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        this.drawROB(g, 630.0, 10.0, this.state.testing);
        this.drawBlocks(g);
        this.drawPlatforms(g);
        this.drawHands(g);
    }
}

