/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.screenshots;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.files.FileUtil;
import nintaco.gui.exportmedia.preferences.ExportMediaFilePrefs;
import nintaco.gui.image.filters.VideoFilterDescriptor;
import nintaco.gui.image.preferences.Paths;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class ScreenshotOptionsDialog
extends JDialog {
    private JButton browseButton;
    private JButton cancelButton;
    private JCheckBox cropBordersCheckBox;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private JComboBox<String> filterComboBox;
    private JLabel filterLabel;
    private JButton okButton;
    private JComboBox<String> paletteComboBox;
    private JLabel paletteLabel;
    private JComboBox<String> scaleComboBox;
    private JLabel scaleLabel;
    private JCheckBox smoothScalingCheckBox;
    private JLabel suffixLabel;
    private JTextField suffixTextField;
    private JCheckBox tvAspectCheckBox;
    private JComboBox<String> typeComboBox;
    private JLabel typeLabel;

    public ScreenshotOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initTypeComboBox();
        this.initPaletteComboBox();
        this.loadFields();
        GuiUtil.addLoseFocusListener((Window)this, this.directoryTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.suffixTextField);
        GuiUtil.addTextFieldEditListener(this.directoryTextField, this::updateOkButton);
        GuiUtil.addTextFieldEditListener(this.suffixTextField, this::updateOkButton);
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initPaletteComboBox() {
        ArrayList<String> names = new ArrayList<String>();
        AppPrefs.getInstance().getPalettes().getPaletteNames(names);
        names.add(0, "[current]");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String name : names) {
            model.addElement(name);
        }
        this.paletteComboBox.setModel(model);
    }

    private void initTypeComboBox() {
        int selectedIndex = 0;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String format : GuiUtil.getWritableImageFileFormats()) {
            if ("png".equalsIgnoreCase(format)) {
                selectedIndex = model.getSize();
            }
            model.addElement(format);
        }
        this.typeComboBox.setModel(model);
        this.typeComboBox.setSelectedIndex(selectedIndex);
    }

    private void loadFields() {
        this.directoryTextField.setText(AppPrefs.getInstance().getPaths().getScreenshotsDir());
        ExportMediaFilePrefs prefs = AppPrefs.getInstance().getScreenshotPrefs();
        this.typeComboBox.setSelectedIndex(prefs.getFileType());
        this.cropBordersCheckBox.setSelected(prefs.isCropBorders());
        this.filterComboBox.setSelectedItem((Object)prefs.getVideoFilter());
        this.paletteComboBox.setSelectedItem(prefs.getPalette());
        this.scaleComboBox.setSelectedIndex(prefs.getScale() - 1);
        this.smoothScalingCheckBox.setSelected(prefs.isSmoothScaling());
        this.tvAspectCheckBox.setSelected(prefs.isUseTvAspectRatio());
        this.suffixTextField.setText(prefs.getSuffix());
        this.updateOkButton();
    }

    private ExportMediaFilePrefs saveFields() {
        String dir = FileUtil.getDirectoryPath(this.directoryTextField.getText().trim());
        if (!StringUtil.isBlank(dir)) {
            Paths paths = AppPrefs.getInstance().getPaths();
            paths.setScreenshotsDir(dir);
            paths.addRecentDirectory(dir);
        }
        ExportMediaFilePrefs prefs = AppPrefs.getInstance().getScreenshotPrefs();
        prefs.setFileType(this.typeComboBox.getSelectedIndex());
        prefs.setCropBorders(this.cropBordersCheckBox.isSelected());
        prefs.setVideoFilter((VideoFilterDescriptor)((Object)this.filterComboBox.getSelectedItem()));
        prefs.setPalette((String)this.paletteComboBox.getSelectedItem());
        prefs.setScale(this.scaleComboBox.getSelectedIndex() + 1);
        prefs.setSmoothScaling(this.smoothScalingCheckBox.isSelected());
        prefs.setUseTvAspectRatio(this.tvAspectCheckBox.isSelected());
        prefs.setSuffix(this.suffixTextField.getText().trim());
        AppPrefs.save();
        return prefs;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void updateOkButton() {
        String directory;
        String suffix = this.suffixTextField.getText().trim();
        if (!suffix.isEmpty()) {
            try {
                String.format(suffix, 123);
            }
            catch (Throwable t) {
                this.okButton.setEnabled(false);
                return;
            }
        }
        this.okButton.setEnabled(!(directory = this.directoryTextField.getText().trim()).isEmpty() && FileUtil.isDirectory(directory));
    }

    private void initComponents() {
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.directoryLabel = new JLabel();
        this.directoryTextField = new JTextField();
        this.browseButton = new JButton();
        this.filterLabel = new JLabel();
        this.filterComboBox = new JComboBox<VideoFilterDescriptor>(VideoFilterDescriptor.values());
        this.scaleLabel = new JLabel();
        this.scaleComboBox = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.cropBordersCheckBox = new JCheckBox();
        this.smoothScalingCheckBox = new JCheckBox();
        this.tvAspectCheckBox = new JCheckBox();
        this.suffixLabel = new JLabel();
        this.suffixTextField = new JTextField();
        this.paletteLabel = new JLabel();
        this.paletteComboBox = new JComboBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Screenshot Options");
        this.setPreferredSize(null);
        this.typeLabel.setText("Type:");
        this.typeComboBox.setFocusable(false);
        this.directoryLabel.setText("Directory:");
        this.directoryTextField.setColumns(50);
        this.directoryTextField.setText(" ");
        this.directoryTextField.setMaximumSize(null);
        this.directoryTextField.setMinimumSize(null);
        this.directoryTextField.setPreferredSize(null);
        this.browseButton.setText("Browse...");
        this.browseButton.setFocusPainted(false);
        this.filterLabel.setText("Filter:");
        this.filterComboBox.setFocusable(false);
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotOptionsDialog.this.filterComboBoxActionPerformed(evt);
            }
        });
        this.scaleLabel.setText("Scale:");
        this.scaleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1x", "2x", "3x", "4x", "5x"}));
        this.scaleComboBox.setFocusable(false);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cropBordersCheckBox.setSelected(true);
        this.cropBordersCheckBox.setText("Crop borders");
        this.cropBordersCheckBox.setFocusPainted(false);
        this.smoothScalingCheckBox.setText("Smooth scaling");
        this.smoothScalingCheckBox.setFocusPainted(false);
        this.tvAspectCheckBox.setText("TV aspect");
        this.tvAspectCheckBox.setFocusPainted(false);
        this.suffixLabel.setText("Suffix:");
        this.suffixTextField.setColumns(15);
        this.suffixTextField.setText("-03d%");
        this.paletteLabel.setText("Palette:");
        this.paletteComboBox.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.directoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cropBordersCheckBox).addGap(18, 18, 18).addComponent(this.smoothScalingCheckBox).addGap(18, 18, 18).addComponent(this.tvAspectCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.paletteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scaleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.suffixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suffixTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoryLabel).addComponent(this.directoryTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scaleLabel).addComponent(this.scaleComboBox, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2).addComponent(this.filterLabel).addComponent(this.filterComboBox, -2, -1, -2).addComponent(this.paletteLabel).addComponent(this.paletteComboBox, -2, -1, -2).addComponent(this.suffixLabel).addComponent(this.suffixTextField, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cropBordersCheckBox).addComponent(this.smoothScalingCheckBox).addComponent(this.tvAspectCheckBox)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void filterComboBoxActionPerformed(ActionEvent evt) {
        VideoFilterDescriptor filter = (VideoFilterDescriptor)((Object)this.filterComboBox.getSelectedItem());
        if (filter == VideoFilterDescriptor.Current) {
            this.scaleLabel.setEnabled(false);
            this.scaleComboBox.setEnabled(false);
            filter = App.getImageFrame().getImagePane().getVideoFilterDescriptor();
            if (filter == null) {
                filter = VideoFilterDescriptor.NoFilter;
            }
        } else {
            this.scaleLabel.setEnabled(true);
            this.scaleComboBox.setEnabled(true);
        }
        this.scaleComboBox.setSelectedIndex(filter == VideoFilterDescriptor.NoFilter ? 0 : filter.getScale() - 1);
        this.smoothScalingCheckBox.setSelected(filter.isSmoothScaling());
        this.tvAspectCheckBox.setSelected(filter.isUseTvAspectRatio());
    }
}

