/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.spritesaver;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import nintaco.Machine;
import nintaco.files.FileUtil;
import nintaco.gui.spritesaver.Metasprite;
import nintaco.palettes.PaletteUtil;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class MetaspriteSet {
    private final Metasprite[] metasprites = new Metasprite[999983];
    private int sweeperSize;
    private int sweepIndex;
    private int metaspriteID;
    private int minOccurrences;

    public MetaspriteSet() {
        this.setSweepSeconds(10);
    }

    public final void setMinOccurrences(int minOccurrences) {
        this.minOccurrences = minOccurrences < 1 ? 1 : minOccurrences;
    }

    public final void setSweepSeconds(int seconds) {
        this.sweeperSize = this.metasprites.length / (120 * MathUtil.clamp(seconds, 1, 300));
    }

    public void sweep() {
        for (int i = this.sweeperSize - 1; i >= 0; --i) {
            while (this.metasprites[this.sweepIndex] != null && this.metasprites[this.sweepIndex].occurrences < this.minOccurrences) {
                this.metasprites[this.sweepIndex] = this.metasprites[this.sweepIndex].next;
            }
            Metasprite parent = this.metasprites[this.sweepIndex];
            if (parent != null) {
                Metasprite metasprite = parent.next;
                while (metasprite != null) {
                    if (metasprite.occurrences < this.minOccurrences) {
                        parent.next = metasprite.next;
                    }
                    parent = metasprite;
                    metasprite = metasprite.next;
                }
            }
            if (++this.sweepIndex < this.metasprites.length) continue;
            this.sweepIndex = 0;
        }
    }

    public int save(Machine machine, String outputDir, String filePrefix, String fileFormat, int imageScale, int startIndex) {
        if (machine == null) {
            return 0;
        }
        ArrayList<Metasprite> list = new ArrayList<Metasprite>();
        for (int i = this.metasprites.length - 1; i >= 0; --i) {
            Metasprite metasprite = this.metasprites[i];
            this.metasprites[i] = null;
            while (metasprite != null) {
                if (metasprite.occurrences >= this.minOccurrences) {
                    list.add(metasprite);
                }
                metasprite = metasprite.next;
            }
        }
        Collections.sort(list);
        FileUtil.mkdir(outputDir);
        String formatStr = FileUtil.appendSeparator(outputDir) + filePrefix + "-%0" + MathUtil.clamp(1 + (int)Math.log10(list.size() + startIndex), 1, 9) + "d." + fileFormat;
        int index = startIndex;
        for (Metasprite metasprite : list) {
            this.save(machine, metasprite, formatStr, fileFormat, index++, imageScale);
        }
        this.metaspriteID = 0;
        return list.size();
    }

    private void save(Machine machine, Metasprite metasprite, String formatStr, String fileFormat, int fileIndex, int imageScale) {
        boolean alphaFormat = GuiUtil.isAlphaFormat(fileFormat);
        int imageWidth = imageScale * metasprite.width;
        BufferedImage image = new BufferedImage(imageWidth, imageScale * metasprite.height, alphaFormat ? 2 : 1);
        int transparentColor = alphaFormat ? 0 : 0x7F7F7F;
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] palette = PaletteUtil.getExtendedPalette(machine);
        byte[] paletteIndices = metasprite.paletteIndices;
        if (imageScale == 1) {
            for (int i = pixels.length - 1; i >= 0; --i) {
                int index = paletteIndices[i] & 0x7F;
                pixels[i] = index == 64 ? transparentColor : 0xFF000000 | palette[index];
            }
        } else {
            int imageScale1 = imageScale - 1;
            for (int y = metasprite.height - 1; y >= 0; --y) {
                int paletteY = y * metasprite.width;
                int py = y * imageScale;
                for (int x = metasprite.width - 1; x >= 0; --x) {
                    int pixelX = x * imageScale;
                    int index = paletteIndices[paletteY + x] & 0x7F;
                    int pixel = index == 64 ? transparentColor : 0xFF000000 | palette[index];
                    for (int i = imageScale1; i >= 0; --i) {
                        int pixelOffset = (py + i) * imageWidth + pixelX;
                        for (int j = imageScale1; j >= 0; --j) {
                            pixels[pixelOffset + j] = pixel;
                        }
                    }
                }
            }
        }
        try {
            ImageIO.write((RenderedImage)image, fileFormat, new File(String.format(formatStr, fileIndex)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean add(byte[][] screen, int x, int y, int width, int height, int hash) {
        int index = (hash & Integer.MAX_VALUE) % this.metasprites.length;
        Metasprite metasprite = this.metasprites[index];
        if (metasprite == null) {
            this.metasprites[index] = this.createMetasprite(screen, x, y, width, height, hash);
            return this.minOccurrences == 1;
        }
        Metasprite parent = null;
        while (true) {
            block9: {
                if (metasprite.hash == hash && metasprite.width == width && metasprite.height == height) {
                    byte[] paletteIndices = metasprite.paletteIndices;
                    for (int i = height - 1; i >= 0; --i) {
                        byte[] row = screen[y + i];
                        int offset = i * width;
                        for (int j = width - 1; j >= 0; --j) {
                            if (row[j + x] == paletteIndices[offset + j]) {
                                continue;
                            }
                            break block9;
                        }
                    }
                    if (parent != null) {
                        parent.next = metasprite.next;
                        metasprite.next = this.metasprites[index].next;
                        this.metasprites[index] = metasprite;
                    }
                    if (metasprite.occurrences < this.minOccurrences) {
                        return ++metasprite.occurrences == this.minOccurrences;
                    }
                    return false;
                }
            }
            if (metasprite.next == null) {
                metasprite.next = this.createMetasprite(screen, x, y, width, height, hash);
                return this.minOccurrences == 1;
            }
            parent = metasprite;
            metasprite = metasprite.next;
        }
    }

    private Metasprite createMetasprite(byte[][] screen, int x, int y, int width, int height, int hash) {
        byte[] paletteIndices = new byte[width * height];
        for (int i = height - 1; i >= 0; --i) {
            System.arraycopy(screen[y + i], x, paletteIndices, i * width, width);
        }
        return new Metasprite(paletteIndices, width, height, hash, this.metaspriteID++);
    }
}

