/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.watchhistory;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JComponent;
import nintaco.gui.historyeditor.tasks.FrameRenderer;
import nintaco.palettes.PaletteUtil;
import nintaco.tv.TVSystem;

public class PreviewPane
extends JComponent
implements FrameRenderer {
    private final BufferedImage image = new BufferedImage(256, 240, 1);
    private final int[] screen = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    private final Dimension preferredSize = new Dimension(256, 240);

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int[] getScreen() {
        return this.screen;
    }

    @Override
    public void render(int[] screen) {
        int[] palette = PaletteUtil.getExtendedPalette(TVSystem.NTSC);
        for (int i = screen.length - 1; i >= 0; --i) {
            this.screen[i] = palette[screen[i]];
        }
    }

    public void drawRectangle() {
        int i;
        for (i = 255; i >= 0; --i) {
            this.screen[i] = 0;
            this.screen[0xEF00 | i] = 0;
        }
        for (i = 238; i > 0; --i) {
            this.screen[i << 8] = 0;
            this.screen[i << 8 | 0xFF] = 0;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
    }

    public void dispose() {
        this.image.flush();
    }
}

