/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import net.java.games.input.Component;
import nintaco.App;
import nintaco.input.ButtonID;
import nintaco.input.ButtonMapping;
import nintaco.input.HoldDownOrToggleButtonMapping;
import nintaco.input.InputDeviceID;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.arkanoid.ArkanoidDescriptor;
import nintaco.input.bandaihypershot.BandaiHyperShotDescriptor;
import nintaco.input.barcodebattler.BarcodeBattlerDescriptor;
import nintaco.input.battlebox.BattleBoxDescriptor;
import nintaco.input.crazyclimber.CrazyClimberLeftDescriptor;
import nintaco.input.crazyclimber.CrazyClimberRightDescriptor;
import nintaco.input.dongda.DongdaPEC586KeyboardDescriptor;
import nintaco.input.doremikkokeyboard.DoremikkoKeyboardDescriptor;
import nintaco.input.excitingboxing.ExcitingBoxingDescriptor;
import nintaco.input.familybasic.datarecorder.DataRecorderDescriptor;
import nintaco.input.familybasic.keyboard.KeyboardDescriptor;
import nintaco.input.familybasic.transformer.TransformerDescriptor;
import nintaco.input.familytrainermat.FamilyTrainerMatDescriptor;
import nintaco.input.gamepad.Gamepad1Descriptor;
import nintaco.input.gamepad.Gamepad2Descriptor;
import nintaco.input.gamepad.Gamepad3Descriptor;
import nintaco.input.gamepad.Gamepad4Descriptor;
import nintaco.input.glasses.GlassesDescriptor;
import nintaco.input.horitrack.HoriTrackDescriptor;
import nintaco.input.konamihypershot.KonamiHyperShotDescriptor;
import nintaco.input.mahjong.MahjongDescriptor;
import nintaco.input.miraclepiano.MiraclePianoDescriptor;
import nintaco.input.none.NoneDescriptor;
import nintaco.input.oekakids.OekaKidsDescriptor;
import nintaco.input.pachinko.PachinkoDescriptor;
import nintaco.input.partytap.PartyTapDescriptor;
import nintaco.input.powerglove.PowerGloveDescriptor;
import nintaco.input.powerpad.PowerPadDescriptor;
import nintaco.input.racermate.RacerMate1Descriptor;
import nintaco.input.racermate.RacerMate2Descriptor;
import nintaco.input.snesmouse.SnesMouseDescriptor;
import nintaco.input.subor.SuborDescriptor;
import nintaco.input.taptapmat.TapTapMatDescriptor;
import nintaco.input.topriderbike.TopRiderBikeDescriptor;
import nintaco.input.turbofile.TurboFileDescriptor;
import nintaco.input.uforce.UForceDescriptor;
import nintaco.input.zapper.ZapperDescriptor;

public abstract class DeviceDescriptor {
    public static final NoneDescriptor None = new NoneDescriptor();
    public static final Gamepad1Descriptor Gamepad1 = new Gamepad1Descriptor();
    public static final Gamepad2Descriptor Gamepad2 = new Gamepad2Descriptor();
    public static final Gamepad3Descriptor Gamepad3 = new Gamepad3Descriptor();
    public static final Gamepad4Descriptor Gamepad4 = new Gamepad4Descriptor();
    public static final ZapperDescriptor Zapper = new ZapperDescriptor();
    public static final ArkanoidDescriptor Arkanoid = new ArkanoidDescriptor();
    public static final BandaiHyperShotDescriptor BandaiHyperShot = new BandaiHyperShotDescriptor();
    public static final BarcodeBattlerDescriptor BarcodeBattler = new BarcodeBattlerDescriptor();
    public static final BattleBoxDescriptor BattleBox = new BattleBoxDescriptor();
    public static final CrazyClimberLeftDescriptor CrazyClimberLeft = new CrazyClimberLeftDescriptor();
    public static final CrazyClimberRightDescriptor CrazyClimberRight = new CrazyClimberRightDescriptor();
    public static final DataRecorderDescriptor DataRecorder = new DataRecorderDescriptor();
    public static final DongdaPEC586KeyboardDescriptor DongdaPEC586Keyboard = new DongdaPEC586KeyboardDescriptor();
    public static final DoremikkoKeyboardDescriptor DoremikkoKeyboard = new DoremikkoKeyboardDescriptor();
    public static final ExcitingBoxingDescriptor ExcitingBoxing = new ExcitingBoxingDescriptor();
    public static final FamilyTrainerMatDescriptor FamilyTrainerMat = new FamilyTrainerMatDescriptor();
    public static final GlassesDescriptor Glasses = new GlassesDescriptor();
    public static final HoriTrackDescriptor HoriTrack = new HoriTrackDescriptor();
    public static final KeyboardDescriptor Keyboard = new KeyboardDescriptor();
    public static final KonamiHyperShotDescriptor KonamiHyperShot = new KonamiHyperShotDescriptor();
    public static final MahjongDescriptor Mahjong = new MahjongDescriptor();
    public static final MiraclePianoDescriptor MiraclePiano = new MiraclePianoDescriptor();
    public static final OekaKidsDescriptor OekaKids = new OekaKidsDescriptor();
    public static final PachinkoDescriptor Pachinko = new PachinkoDescriptor();
    public static final PartyTapDescriptor PartyTap = new PartyTapDescriptor();
    public static final PowerGloveDescriptor PowerGlove = new PowerGloveDescriptor();
    public static final PowerPadDescriptor PowerPad = new PowerPadDescriptor();
    public static final RacerMate1Descriptor RacerMate1 = new RacerMate1Descriptor();
    public static final RacerMate2Descriptor RacerMate2 = new RacerMate2Descriptor();
    public static final SnesMouseDescriptor SnesMouse = new SnesMouseDescriptor();
    public static final SuborDescriptor Subor = new SuborDescriptor();
    public static final TapTapMatDescriptor TapTapMat = new TapTapMatDescriptor();
    public static final TopRiderBikeDescriptor TopRiderBike = new TopRiderBikeDescriptor();
    public static final TransformerDescriptor TransformerKeyboard = new TransformerDescriptor();
    public static final TurboFileDescriptor TurboFile = new TurboFileDescriptor();
    public static final UForceDescriptor UForce = new UForceDescriptor();
    protected final int inputDevice;
    protected volatile boolean holdDownRewindTime;
    protected volatile boolean holdDownHighSpeed;
    protected boolean rewindTimePressed;
    protected boolean highSpeedPressed;

    public static DeviceDescriptor getDescriptor(int inputDevice) {
        switch (inputDevice) {
            case 0: {
                return Gamepad1;
            }
            case 1: {
                return Gamepad2;
            }
            case 2: {
                return Gamepad3;
            }
            case 3: {
                return Gamepad4;
            }
            case 4: {
                return Zapper;
            }
            case 5: {
                return Arkanoid;
            }
            case 6: {
                return BandaiHyperShot;
            }
            case 7: {
                return BarcodeBattler;
            }
            case 8: {
                return BattleBox;
            }
            case 9: {
                return CrazyClimberLeft;
            }
            case 10: {
                return CrazyClimberRight;
            }
            case 11: {
                return DataRecorder;
            }
            case 12: {
                return DongdaPEC586Keyboard;
            }
            case 13: {
                return DoremikkoKeyboard;
            }
            case 14: {
                return ExcitingBoxing;
            }
            case 15: {
                return FamilyTrainerMat;
            }
            case 16: {
                return Glasses;
            }
            case 18: {
                return Keyboard;
            }
            case 19: {
                return KonamiHyperShot;
            }
            case 17: {
                return HoriTrack;
            }
            case 20: {
                return Mahjong;
            }
            case 21: {
                return MiraclePiano;
            }
            case 22: {
                return OekaKids;
            }
            case 23: {
                return Pachinko;
            }
            case 24: {
                return PartyTap;
            }
            case 25: {
                return PowerGlove;
            }
            case 26: {
                return PowerPad;
            }
            case 27: {
                return RacerMate1;
            }
            case 28: {
                return RacerMate2;
            }
            case 29: {
                return SnesMouse;
            }
            case 30: {
                return Subor;
            }
            case 31: {
                return TapTapMat;
            }
            case 32: {
                return TopRiderBike;
            }
            case 33: {
                return TransformerKeyboard;
            }
            case 34: {
                return TurboFile;
            }
            case 35: {
                return UForce;
            }
        }
        return None;
    }

    protected DeviceDescriptor(int inputDevice) {
        this.inputDevice = inputDevice;
    }

    public abstract String getDeviceName();

    public abstract int getButtonCount();

    public abstract String getButtonName(int var1);

    public abstract ButtonMapping getDefaultButtonMapping(int var1);

    public abstract int setButtonBits(int var1, int var2, int var3, int[] var4);

    public int getRewindTimeButton() {
        return -1;
    }

    public int getHighSpeedButton() {
        return -1;
    }

    private boolean isHoldDownOrToggle(Inputs inputs, int buttonIndex) {
        HoldDownOrToggleButtonMapping buttonMapping;
        if (buttonIndex >= 0 && (buttonMapping = (HoldDownOrToggleButtonMapping)inputs.getButtonMapping(this.inputDevice, buttonIndex)) != null) {
            return buttonMapping.isHoldDown();
        }
        return false;
    }

    public void handleSettingsChange(Inputs inputs) {
        this.holdDownRewindTime = this.isHoldDownOrToggle(inputs, this.getRewindTimeButton());
        this.holdDownHighSpeed = this.isHoldDownOrToggle(inputs, this.getHighSpeedButton());
    }

    public int getInputDevice() {
        return this.inputDevice;
    }

    public ButtonMapping getButtonMapping(int button, ButtonID[] buttonIds) {
        if (button == this.getRewindTimeButton() || button == this.getHighSpeedButton()) {
            return new HoldDownOrToggleButtonMapping(this.inputDevice, button, buttonIds, false);
        }
        return new ButtonMapping(this.inputDevice, button, buttonIds);
    }

    public ButtonMapping getNoButtonMapping(int button) {
        if (button == this.getRewindTimeButton() || button == this.getHighSpeedButton()) {
            return new HoldDownOrToggleButtonMapping(this.inputDevice, button);
        }
        return new ButtonMapping(this.inputDevice, button);
    }

    protected ButtonMapping getDefaultButtonMapping(InputDeviceID device, int buttonIndex, Component.Identifier[] defaults) {
        if (device != null && defaults != null && buttonIndex < defaults.length) {
            return this.getButtonMapping(buttonIndex, new ButtonID[]{new ButtonID(device, defaults[buttonIndex].getName(), 1)});
        }
        return this.getNoButtonMapping(buttonIndex);
    }

    protected void updateRewindTime(boolean rewindTime, int portIndex) {
        if (InputUtil.isInputDisabled()) {
            rewindTime = false;
        }
        if (rewindTime) {
            if (!this.rewindTimePressed) {
                this.rewindTimePressed = true;
                if (this.holdDownRewindTime) {
                    App.requestRewindTime(portIndex, true);
                } else {
                    App.requestRewindTime(portIndex);
                }
            }
        } else if (this.rewindTimePressed) {
            this.rewindTimePressed = false;
            if (this.holdDownRewindTime) {
                App.requestRewindTime(portIndex, false);
            }
        }
    }

    protected void updateHighSpeed(boolean highSpeed, int portIndex) {
        if (InputUtil.isInputDisabled()) {
            highSpeed = false;
        }
        if (highSpeed) {
            if (!this.highSpeedPressed) {
                this.highSpeedPressed = true;
                if (this.holdDownHighSpeed) {
                    App.requestHighSpeed(portIndex, true);
                } else {
                    App.requestHighSpeed(portIndex);
                }
            }
        } else if (this.highSpeedPressed) {
            this.highSpeedPressed = false;
            if (this.holdDownHighSpeed) {
                App.requestHighSpeed(portIndex, false);
            }
        }
    }

    public int hashCode() {
        return this.inputDevice;
    }

    public boolean equals(Object obj) {
        return obj != null && this.inputDevice == ((DeviceDescriptor)obj).inputDevice;
    }

    public String toString() {
        return this.getDeviceName();
    }
}

