/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic.datarecorder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import nintaco.util.MathUtil;

public class BitList
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int BLOCK_SIZE = 2048;
    private transient int[] data;
    private int capacity;
    private int size;

    private void ensureCapacity() {
        if (this.data == null) {
            this.data = new int[0];
        }
        if (this.capacity < this.size + 1) {
            int[] d = new int[this.data.length + 2048];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
            this.capacity = this.data.length << 5;
        }
    }

    public void add(boolean value) {
        this.add(value ? 1 : 0);
    }

    public void add(int value) {
        this.ensureCapacity();
        int n = this.size >> 5;
        this.data[n] = this.data[n] | (value & 1) << (this.size & 0x1F);
        ++this.size;
    }

    public boolean getBool(int index) {
        return this.get(index) == 1;
    }

    public int get(int index) {
        return this.data[index >> 5] >> (index & 0x1F) & 1;
    }

    public void clear() {
        this.data = new int[0];
        this.size = 0;
        this.capacity = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void save(DataOutputStream out) throws Throwable {
        this.ensureCapacity();
        int length = Math.min(this.data.length, MathUtil.roundUpDivision(this.size, 32));
        out.writeInt(this.capacity);
        out.writeInt(this.size);
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeInt(this.data[i]);
        }
    }

    public void load(DataInputStream in) throws Throwable {
        try {
            this.capacity = in.readInt();
            this.size = in.readInt();
            int length = in.readInt();
            this.data = new int[this.capacity >> 5];
            for (int i = 0; i < length; ++i) {
                this.data[i] = in.readInt();
            }
        }
        catch (Throwable t) {
            this.clear();
            throw t;
        }
    }
}

