/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic.keyboard;

import java.io.Serializable;
import nintaco.Machine;
import nintaco.input.DeviceMapper;
import nintaco.input.familybasic.datarecorder.DataRecorderMapper;
import nintaco.input.familybasic.keyboard.KeyboardDescriptor;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class KeyboardMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][] KEYS = new int[][]{{39, 2, 1}, {41, 8, 1}, {38, 8, 0}, {39, 11, 0}, {42, 11, 0}, {40, 14, 1}, {39, 5, 0}, {42, 5, 0}, {34, 2, 1}, {35, 8, 0}, {36, 11, 0}, {33, 11, 0}, {37, 14, 0}, {34, 14, 0}, {33, 5, 0}, {36, 5, 0}, {29, 2, 1}, {29, 8, 0}, {30, 11, 0}, {27, 11, 0}, {31, 14, 0}, {28, 14, 0}, {32, 8, 0}, {30, 5, 0}, {24, 2, 1}, {26, 8, 0}, {23, 8, 0}, {24, 11, 0}, {25, 14, 0}, {22, 14, 0}, {27, 5, 0}, {24, 5, 0}, {19, 2, 1}, {20, 8, 0}, {18, 11, 0}, {15, 11, 0}, {19, 14, 0}, {16, 14, 0}, {21, 5, 0}, {18, 5, 0}, {14, 2, 1}, {17, 8, 0}, {14, 8, 0}, {12, 11, 0}, {15, 11, 0}, {13, 14, 0}, {15, 5, 0}, {12, 5, 0}, {9, 2, 1}, {8, 8, 0}, {9, 11, 0}, {6, 11, 0}, {10, 14, 0}, {7, 14, 0}, {11, 8, 0}, {9, 5, 0}, {4, 2, 1}, {2, 8, 0}, {5, 8, 0}, {3, 11, 0}, {2, 14, 1}, {10, 17, 0}, {3, 5, 0}, {6, 5, 0}, {48, 6, 0}, {50, 9, 1}, {53, 12, 1}, {47, 12, 1}, {50, 15, 1}, {13, 17, 2}, {54, 6, 0}, {51, 6, 0}};
    private final int[][] KeyMatrix = new int[10][2];
    private final boolean[] PressedKeys = new boolean[72];
    private final DataRecorderMapper dataRecorderMapper = new DataRecorderMapper();
    private int row;
    private int column;
    private boolean enabled;

    @Override
    public int getInputDevice() {
        return 18;
    }

    @Override
    public void setMachine(Machine machine) {
        this.dataRecorderMapper.setMachine(machine);
    }

    public DataRecorderMapper getDataRecorder() {
        return this.dataRecorderMapper;
    }

    @Override
    public void update(int buttons) {
        int i;
        this.dataRecorderMapper.update(buttons);
        for (i = 9; i >= 0; --i) {
            this.KeyMatrix[i][0] = 30;
            this.KeyMatrix[i][1] = 30;
        }
        for (i = 71; i >= 0; --i) {
            this.PressedKeys[i] = false;
        }
        this.setKeyBit(buttons >> 16 & 0x7F);
        this.setKeyBit(buttons >> 23 & 0x7F);
        if ((buttons & 0x40000000) != 0) {
            this.setKeyBit(KeyboardDescriptor.KEY_MAP[68]);
        }
        if ((buttons & Integer.MIN_VALUE) != 0) {
            this.setKeyBit(KeyboardDescriptor.KEY_MAP[69]);
        }
        if ((buttons & 0x400) != 0) {
            this.setKeyBit(KeyboardDescriptor.KEY_MAP[70]);
        }
        if ((buttons & 0x800) != 0) {
            this.setKeyBit(KeyboardDescriptor.KEY_MAP[71]);
        }
    }

    private void setKeyBit(int key) {
        if (key < 72) {
            int[] nArray = this.KeyMatrix[key >> 3];
            int n = key >> 2 & 1;
            nArray[n] = nArray[n] & ~(1 << 1 + (key & 3));
            this.PressedKeys[key] = true;
        }
    }

    @Override
    public void writePort(int value) {
        this.dataRecorderMapper.writePort(value);
        this.enabled = BitUtil.getBitBool(value, 2);
        if (this.enabled) {
            int col = BitUtil.getBit(value, 1);
            if (this.column == 1 && col == 0 && ++this.row == 10) {
                this.row = 0;
            }
            this.column = col;
            if (BitUtil.getBitBool(value, 0)) {
                this.row = 0;
            }
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            if (this.enabled) {
                return this.KeyMatrix[this.row][this.column];
            }
            return 30;
        }
        return this.dataRecorderMapper.readPort(0);
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 1 ? this.readPort(1) : this.dataRecorderMapper.peekPort(0);
    }

    @Override
    public void render(int[] screen) {
        int x = 163;
        int y = 205;
        InputIcons.FamilyBasicKeyboard.render(screen, 163, 205);
        for (int i = 71; i >= 0; --i) {
            if (!this.PressedKeys[i]) continue;
            int[] K = KEYS[i];
            (K[2] == 0 ? InputIcons.FamilyBasicKeyboardKey : (K[2] == 1 ? InputIcons.FamilyBasicKeyboardShift : InputIcons.FamilyBasicKeyboardSpace)).render(screen, 163 + K[0], 205 + K[1]);
        }
    }
}

