/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.gamepad;

import java.io.Serializable;
import nintaco.App;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.cartdb.Cart;
import nintaco.cartdb.CartDB;
import nintaco.input.DeviceMapper;

public abstract class LagDeviceMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int LAG_SCANLINE = 128;
    protected int buttons;
    private int buttonsBuffer;
    private boolean lagButtons;
    private volatile PPU ppu;

    public LagDeviceMapper() {
        Cart cart = App.getCart();
        if (cart != null && CartDB.isEnabled()) {
            this.lagButtons = cart.isLagButtons();
        }
    }

    @Override
    public void setMachine(Machine machine) {
        this.ppu = machine == null ? null : machine.getPPU();
    }

    @Override
    public void update(int buttons) {
        if (this.lagButtons) {
            this.buttons = this.buttonsBuffer;
            this.buttonsBuffer = buttons;
        } else {
            this.buttons = buttons;
        }
    }

    protected void updateButtons() {
        PPU p;
        if (this.lagButtons && (p = this.ppu) != null && p.getScanline() >= 128) {
            this.buttons = this.buttonsBuffer;
        }
    }
}

