/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.horitrack;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.gamepad.Autofire;

public class HoriTrackDescriptor
extends DeviceDescriptor {
    public static final int A = 0;
    public static final int B = 1;
    public static final int Select = 2;
    public static final int Start = 3;
    public static final int Up = 4;
    public static final int Down = 5;
    public static final int Left = 6;
    public static final int Right = 7;
    public static final int AutofireA = 8;
    public static final int AutofireB = 9;
    public static final int ToggleAutofire = 10;
    public static final int ToggleSpeed = 11;
    public static final int ToggleOrientation = 12;
    public static final int RewindTime = 13;
    private static final Component.Identifier[] DEFAULTS = new Component.Identifier[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.RIGHT, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.UP, Component.Identifier.Key.DOWN, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.S, Component.Identifier.Key.A, Component.Identifier.Key.Q, Component.Identifier.Key.P, Component.Identifier.Key.O, Component.Identifier.Key.EQUALS};
    private static final int[][] SPEED_THRESHOLDS = new int[][]{{0, 4, 8, 16, 24}, {1, 16, 32, 48, 56}};
    private final Autofire autofire = new Autofire(2);
    private boolean toggleOrientationHeld;
    private boolean orientedLeft;
    private boolean toggleSpeedHeld;
    private boolean lowSpeed;
    private int mouseX = 127;
    private int mouseY = 119;
    private volatile boolean allowImpossibleInput;

    public HoriTrackDescriptor() {
        super(17);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.allowImpossibleInput = inputs.isAllowImpossibleInput();
        this.autofire.setRate(inputs.getAutofireRate() - 1);
    }

    @Override
    public String getDeviceName() {
        return "Hori Track";
    }

    @Override
    public int getButtonCount() {
        return 14;
    }

    @Override
    public int getRewindTimeButton() {
        return 13;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "Select";
            }
            case 3: {
                return "Start";
            }
            case 4: {
                return "Up";
            }
            case 5: {
                return "Down";
            }
            case 6: {
                return "Left";
            }
            case 7: {
                return "Right";
            }
            case 8: {
                return "Autofire A";
            }
            case 9: {
                return "Autofire B";
            }
            case 10: {
                return "Toggle Autofire";
            }
            case 11: {
                return "Toggle Speed";
            }
            case 12: {
                return "Toggle Orientation";
            }
            case 13: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(buttonIndex == 0 || buttonIndex == 1 ? InputUtil.getDefaultMouse() : InputUtil.getDefaultKeyboard(), buttonIndex, DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        boolean toggleSpeed;
        boolean toggleOrientation;
        this.autofire.setToggle(pressedValues[10] != 0);
        this.autofire.buttonStates[0].update(pressedValues[8] != 0, pressedValues[0] != 0);
        this.autofire.buttonStates[1].update(pressedValues[9] != 0, pressedValues[1] != 0);
        boolean bl = toggleOrientation = pressedValues[12] != 0;
        if (toggleOrientation != this.toggleOrientationHeld) {
            this.toggleOrientationHeld = toggleOrientation;
            if (toggleOrientation) {
                this.orientedLeft = !this.orientedLeft;
            }
        }
        boolean bl2 = toggleSpeed = pressedValues[11] != 0;
        if (toggleSpeed != this.toggleSpeedHeld) {
            this.toggleSpeedHeld = toggleSpeed;
            if (toggleSpeed) {
                this.lowSpeed = !this.lowSpeed;
            }
        }
        this.updateRewindTime(pressedValues[13] != 0, portIndex);
        int buttons = 0;
        if (this.allowImpossibleInput) {
            if (pressedValues[7] != 0) {
                buttons |= 0x800000;
            }
            if (pressedValues[6] != 0) {
                buttons |= 0x400000;
            }
            if (pressedValues[5] != 0) {
                buttons |= 0x200000;
            }
            if (pressedValues[4] != 0) {
                buttons |= 0x100000;
            }
        } else {
            if (pressedValues[7] > pressedValues[6]) {
                buttons |= 0x800000;
            }
            if (pressedValues[6] > pressedValues[7]) {
                buttons |= 0x400000;
            }
            if (pressedValues[5] > pressedValues[4]) {
                buttons |= 0x200000;
            }
            if (pressedValues[4] > pressedValues[5]) {
                buttons |= 0x100000;
            }
        }
        if (pressedValues[3] != 0) {
            buttons |= 0x80000;
        }
        if (pressedValues[2] != 0) {
            buttons |= 0x40000;
        }
        if (this.lowSpeed) {
            buttons |= 0x800;
        }
        if (this.orientedLeft) {
            buttons |= 0x400;
        }
        if (this.autofire.buttonStates[1].asserted || !this.autofire.enabled && pressedValues[1] != 0) {
            buttons |= 0x20000;
        }
        if (this.autofire.buttonStates[0].asserted || !this.autofire.enabled && pressedValues[0] != 0) {
            buttons |= 0x10000;
        }
        int[] thresholds = SPEED_THRESHOLDS[this.lowSpeed ? 1 : 0];
        int deltaX = this.mouseX;
        int deltaY = this.mouseY;
        int mouse = InputUtil.getMouseCoordinates();
        int y = mouse >> 8 & 0xFF;
        if (y < 240) {
            this.mouseX = mouse & 0xFF;
            this.mouseY = y;
        }
        buttons = (deltaX -= this.mouseX) > thresholds[0] ? (buttons |= deltaX >= thresholds[4] ? 0x1000000 : (deltaX >= thresholds[3] ? 0x9000000 : (deltaX >= thresholds[2] ? 0x5000000 : (deltaX >= thresholds[1] ? 0x3000000 : 0x7000000)))) : (deltaX < -thresholds[0] ? (buttons |= deltaX <= -thresholds[4] ? 0x6000000 : (deltaX <= -thresholds[3] ? 0x2000000 : (deltaX <= -thresholds[2] ? 0x4000000 : (deltaX <= -thresholds[1] ? 0x8000000 : 0)))) : (buttons |= 0xF000000));
        buttons = deltaY > thresholds[0] ? (buttons |= deltaY >= thresholds[4] ? 0x60000000 : (deltaY >= thresholds[3] ? 0x20000000 : (deltaY >= thresholds[2] ? 0x40000000 : (deltaY >= thresholds[1] ? Integer.MIN_VALUE : 0)))) : (deltaY < -thresholds[0] ? (buttons |= deltaY <= -thresholds[4] ? 0x10000000 : (deltaY <= -thresholds[3] ? -1879048192 : (deltaY <= -thresholds[2] ? 0x50000000 : ((deltaY -= this.mouseY) <= -thresholds[1] ? 0x30000000 : 0x70000000)))) : (buttons |= 0xF0000000));
        return buttons | bits;
    }
}

