/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.icons;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import nintaco.palettes.PalettePPU;

public enum InputIcons {
    Arkanoid("arkanoid", false),
    BandaiHyperShot("bandaihypershot", false),
    BandaiHyperShotTrigger("bandaihypershot-trigger", true),
    Doremikko("doremikko", false),
    DoremikkoBlack("doremikko-black", true),
    DoremikkoWhite1("doremikko-white1", true),
    DoremikkoWhite2("doremikko-white2", true),
    ExcitingBoxing("excitingboxing", false),
    ExcitingBoxingLeft("excitingboxing-left", true),
    ExcitingBoxingRight("excitingboxing-right", true),
    FamilyBasicKeyboard("familybasickeyboard", false),
    FamilyBasicKeyboardKey("familybasickeyboard-key", true),
    FamilyBasicKeyboardShift("familybasickeyboard-shift", true),
    FamilyBasicKeyboardSpace("familybasickeyboard-space", true),
    Gamepad("gamepad", false),
    GamepadAB("gamepad-ab", true),
    GamepadDPad("gamepad-dpad", true),
    GamepadStart("gamepad-start", true),
    HoriTrack("horitrack", false),
    KonamiHyperShot("konamihypershot", false),
    KonamiHyperShotButton("konamihypershot-button", true),
    Mahjong("mahjong", false),
    Miracle("miracle", false),
    MiracleButton("miracle-button", true),
    MiracleDown("miracle-down", true),
    MiraclePedal("miracle-pedal", true),
    MiracleUp("miracle-up", true),
    Pachinko("pachinko", false),
    PachinkoDown("pachinko-down", true),
    PachinkoUp("pachinko-up", true),
    PartyTap("partytap", false),
    PartyTapButton("partytap-button", true),
    PowerPad("powerpad", false),
    RacerMate("racermate", false),
    RacerMateButton("racermate-button", true),
    RacerMateLeftPedal("racermate-left-pedal", true),
    RacerMateRightPedal("racermate-right-pedal", true),
    SuborKeyboard("suborkeyboard", false),
    SuborKeyboard3("suborkeyboard-3", true),
    SuborKeyboard5("suborkeyboard-5", true),
    SuborKeyboardEnter("suborkeyboard-enter", true),
    SuborKeyboardSpace("suborkeyboard-space", true),
    SuborKeyboardVertical("suborkeyboard-vertical", true),
    TapTapMat("taptapmat", false),
    TopRider("toprider", false),
    TopRiderBrake("toprider-brake", true),
    TopRiderHandle("toprider-handle", true),
    TopRiderShift("toprider-shift", true),
    Transformer("transformer", false),
    UForce("uforce", false),
    Zapper("zapper", false),
    ZapperTarget("zapper-target", false),
    ZapperTrigger("zapper-trigger", true);

    private static final int TRANSPARENT = -1;
    private static final int DARK_GRAY = 0;
    private static final int GRAY = 16;
    private static final int BLACK = 15;
    private static final int WHITE = 48;
    private static int paletteIndex;
    private final int width;
    private final int height;
    private final int[][] pixels;

    public static void setPalettePPU(PalettePPU palettePPU) {
        paletteIndex = palettePPU.getIndex();
    }

    private InputIcons(String file, boolean button) {
        int w = 0;
        int h = 0;
        int[] ps = null;
        try {
            BufferedImage image = ImageIO.read(InputIcons.class.getResource(file + ".png"));
            w = image.getWidth();
            h = image.getHeight();
            ps = new int[w * h];
            image.getRGB(0, 0, w, h, ps, 0, w);
            for (int i = ps.length - 1; i >= 0; --i) {
                ps[i] = (ps[i] & 0xFF000000) == 0 ? -1 : (button ? 48 : ((ps[i] & 0xFFFFFF) == 0 ? 15 : ((ps[i] & 0xFFFFFF) == 0x666666 ? 0 : 16)));
            }
        }
        catch (Throwable image) {
            // empty catch block
        }
        this.width = w;
        this.height = h;
        PalettePPU[] values = PalettePPU.values();
        this.pixels = new int[values.length][ps.length];
        for (PalettePPU palettePPU : values) {
            int[] pix = this.pixels[palettePPU.getIndex()];
            int[] map = palettePPU.getMap();
            for (int i = ps.length - 1; i >= 0; --i) {
                int color = ps[i];
                pix[i] = color == -1 ? -1 : map[ps[i]];
            }
        }
    }

    public void render(int[] screen, int x, int y) {
        int[] pix = this.pixels[paletteIndex];
        int i = 0;
        int k = 0;
        int s = y << 8 | x;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                int p = pix[k];
                if (p >= 0) {
                    screen[s + j] = p;
                }
                ++j;
                ++k;
            }
            ++i;
            s += 256;
        }
    }

    public void renderSafe(int[] screen, int x, int y) {
        int[] pix = this.pixels[paletteIndex];
        int x2 = x + this.width - 1;
        int y2 = y + this.height - 1;
        if (x > 255 || y > 239 || x2 < 0 || y2 < 0) {
            return;
        }
        int xMin = x < 0 ? -x : 0;
        int yMin = y < 0 ? -y : 0;
        int xMax = x2 > 255 ? 255 - x : this.width - 1;
        int yMax = y2 > 239 ? 239 - y : this.height - 1;
        for (int i = yMin; i <= yMax; ++i) {
            int po = this.width * i;
            int s = (y + i << 8) + x;
            for (int j = xMin; j <= xMax; ++j) {
                int p = pix[po + j];
                if (p < 0) continue;
                screen[s + j] = p;
            }
        }
    }
}

